/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneContext;
import org.apache.cayenne.CayenneContextMergeHandler;
import org.apache.cayenne.ObjectContextChangeLog;
import org.apache.cayenne.ObjectContextStateLog;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.graph.ArcCreateOperation;
import org.apache.cayenne.graph.ArcDeleteOperation;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.graph.GraphMap;
import org.apache.cayenne.graph.NodeCreateOperation;
import org.apache.cayenne.graph.NodeDeleteOperation;
import org.apache.cayenne.graph.NodeIdChangeOperation;
import org.apache.cayenne.graph.NodePropertyChangeOperation;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.ToManyMapProperty;
import org.apache.cayenne.util.PersistentObjectMap;

final class CayenneContextGraphManager
extends GraphMap {
    static final String COMMIT_MARKER = "commit";
    static final String FLUSH_MARKER = "flush";
    CayenneContext context;
    Collection<Object> deadIds;
    boolean changeEventsEnabled;
    boolean lifecycleEventsEnabled;
    ObjectContextStateLog stateLog;
    ObjectContextChangeLog changeLog;

    CayenneContextGraphManager(CayenneContext context, boolean changeEventsEnabled, boolean lifecycleEventsEnabled) {
        this.context = context;
        this.changeEventsEnabled = changeEventsEnabled;
        this.lifecycleEventsEnabled = lifecycleEventsEnabled;
        this.stateLog = new ObjectContextStateLog((GraphManager)this);
        this.changeLog = new ObjectContextChangeLog();
    }

    boolean hasChanges() {
        return this.changeLog.size() > 0;
    }

    boolean hasChangesSinceLastFlush() {
        int size = this.changeLog.hasMarker(FLUSH_MARKER) ? this.changeLog.sizeAfterMarker(FLUSH_MARKER) : this.changeLog.size();
        return size > 0;
    }

    GraphDiff getDiffs() {
        return this.changeLog.getDiffs();
    }

    GraphDiff getDiffsSinceLastFlush() {
        return this.changeLog.hasMarker(FLUSH_MARKER) ? this.changeLog.getDiffsAfterMarker(FLUSH_MARKER) : this.changeLog.getDiffs();
    }

    Collection<Object> dirtyNodes() {
        return this.stateLog.dirtyNodes();
    }

    Collection<Object> dirtyNodes(int state) {
        return this.stateLog.dirtyNodes(state);
    }

    public synchronized Object unregisterNode(Object nodeId) {
        Object node = super.unregisterNode(nodeId);
        if (node != null) {
            this.stateLog.unregisterNode(nodeId);
            this.changeLog.unregisterNode(nodeId);
            Persistent object = (Persistent)node;
            object.setObjectContext(null);
            object.setPersistenceState(1);
            return node;
        }
        return null;
    }

    void graphCommitAborted() {
        this.changeLog.removeMarker(COMMIT_MARKER);
    }

    void graphCommitStarted() {
        this.changeLog.setMarker(COMMIT_MARKER);
    }

    void graphCommitted(GraphDiff parentSyncDiff) {
        if (parentSyncDiff != null) {
            new CayenneContextMergeHandler(this.context).merge(parentSyncDiff);
        }
        this.remapTargets();
        this.stateLog.graphCommitted();
        this.reset();
        if (this.lifecycleEventsEnabled) {
            this.context.fireDataChannelCommitted(this.context.getChannel(), parentSyncDiff);
        }
    }

    private void remapTargets() {
        Iterator it = this.stateLog.dirtyIds().iterator();
        EntityResolver resolver = this.context.getEntityResolver();
        while (it.hasNext()) {
            ObjectId id = (ObjectId)it.next();
            ClassDescriptor descriptor = resolver.getClassDescriptor(id.getEntityName());
            Collection mapArcProperties = descriptor.getMapArcProperties();
            if (mapArcProperties.isEmpty()) continue;
            Object object = this.getNode(id);
            for (ArcProperty arc : mapArcProperties) {
                ToManyMapProperty reverseArc = (ToManyMapProperty)arc.getComplimentaryReverseArc();
                Object source = arc.readPropertyDirectly(object);
                if (source == null || reverseArc.isFault(source)) continue;
                this.remapTarget(reverseArc, source, object);
            }
        }
    }

    private final void remapTarget(ToManyMapProperty property, Object source, Object target) throws PropertyException {
        Object newKey;
        Map map = (Map)property.readProperty(source);
        Object currentValue = map.get(newKey = property.getMapKey(target));
        if (currentValue == target) {
            return;
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (e.getValue() != target) continue;
            it.remove();
            break;
        }
        ((PersistentObjectMap)map).putDirectly(newKey, target);
    }

    void graphFlushed() {
        this.changeLog.setMarker(FLUSH_MARKER);
    }

    void graphReverted() {
        GraphDiff diff = this.changeLog.getDiffs();
        diff.undo((GraphChangeHandler)new RollbackChangeHandler());
        this.stateLog.graphReverted();
        this.reset();
        if (this.lifecycleEventsEnabled) {
            this.context.fireDataChannelRolledback((Object)this.context, diff);
        }
    }

    public synchronized void nodeIdChanged(Object nodeId, Object newId) {
        this.stateLog.nodeIdChanged(nodeId, newId);
        this.processChange((GraphDiff)new NodeIdChangeOperation(nodeId, newId));
    }

    public synchronized void nodeCreated(Object nodeId) {
        this.stateLog.nodeCreated(nodeId);
        this.processChange((GraphDiff)new NodeCreateOperation(nodeId));
    }

    public synchronized void nodeRemoved(Object nodeId) {
        this.stateLog.nodeRemoved(nodeId);
        this.processChange((GraphDiff)new NodeDeleteOperation(nodeId));
    }

    public synchronized void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        this.stateLog.nodePropertyChanged(nodeId, property, oldValue, newValue);
        this.processChange((GraphDiff)new NodePropertyChangeOperation(nodeId, property, oldValue, newValue));
    }

    public synchronized void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
        this.stateLog.arcCreated(nodeId, targetNodeId, arcId);
        this.processChange((GraphDiff)new ArcCreateOperation(nodeId, targetNodeId, arcId));
    }

    public synchronized void arcDeleted(Object nodeId, Object targetNodeId, ArcId arcId) {
        this.stateLog.arcDeleted(nodeId, targetNodeId, arcId);
        this.processChange((GraphDiff)new ArcDeleteOperation(nodeId, targetNodeId, arcId));
    }

    private void processChange(GraphDiff diff) {
        this.changeLog.addOperation(diff);
        if (this.changeEventsEnabled) {
            this.context.fireDataChannelChanged((Object)this.context, diff);
        }
    }

    void send(GraphDiff diff, EventSubject subject, Object eventSource) {
        EventManager manager;
        EventManager eventManager = manager = this.context.getChannel() != null ? this.context.getChannel().getEventManager() : null;
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this.context, eventSource, diff);
            manager.postEvent((EventObject)e, subject);
        }
    }

    void reset() {
        this.changeLog.reset();
        if (this.deadIds != null) {
            for (Object deadId : this.deadIds) {
                this.nodes.remove(deadId);
            }
            this.deadIds = null;
        }
    }

    Collection<Object> deadIds() {
        if (this.deadIds == null) {
            this.deadIds = new ArrayList<Object>();
        }
        return this.deadIds;
    }

    class RollbackChangeHandler
    implements GraphChangeHandler {
        RollbackChangeHandler() {
        }

        public void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
            CayenneContextGraphManager.this.context.mergeHandler.arcCreated(nodeId, targetNodeId, arcId);
            CayenneContextGraphManager.this.arcCreated(nodeId, targetNodeId, arcId);
        }

        public void arcDeleted(Object nodeId, Object targetNodeId, ArcId arcId) {
            CayenneContextGraphManager.this.context.mergeHandler.arcDeleted(nodeId, targetNodeId, arcId);
            CayenneContextGraphManager.this.arcDeleted(nodeId, targetNodeId, arcId);
        }

        public void nodeCreated(Object nodeId) {
            CayenneContextGraphManager.this.nodeCreated(nodeId);
        }

        public void nodeIdChanged(Object nodeId, Object newId) {
            CayenneContextGraphManager.this.nodeIdChanged(nodeId, newId);
        }

        public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
            CayenneContextGraphManager.this.context.mergeHandler.nodePropertyChanged(nodeId, property, oldValue, newValue);
            CayenneContextGraphManager.this.nodePropertyChanged(nodeId, property, oldValue, newValue);
        }

        public void nodeRemoved(Object nodeId) {
            CayenneContextGraphManager.this.nodeRemoved(nodeId);
        }
    }
}

