/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.AccessorFactory;
import org.apache.cayenne.reflect.BeanAccessor;
import org.apache.cayenne.reflect.MapAccessor;
import org.apache.cayenne.reflect.PropertyException;

public class PropertyUtils {
    private static final ConcurrentMap<String, Accessor> PATH_ACCESSORS = new ConcurrentHashMap<String, Accessor>();
    private static final ConcurrentMap<Class<?>, ConcurrentMap<String, Accessor>> SEGMENT_ACCESSORS = new ConcurrentHashMap();
    private static AccessorFactory accessorFactory = BeanAccessor::new;

    public static Accessor accessor(String nestedPropertyName) {
        if (nestedPropertyName == null) {
            throw new IllegalArgumentException("Null property name.");
        }
        if (nestedPropertyName.length() == 0) {
            throw new IllegalArgumentException("Empty property name.");
        }
        return PropertyUtils.compilePathAccessor(nestedPropertyName);
    }

    static Accessor compilePathAccessor(String path) {
        Accessor accessor = (Accessor)PATH_ACCESSORS.get(path);
        if (accessor == null) {
            int dot = path.indexOf(".");
            if (dot == 0 || dot == path.length() - 1) {
                throw new IllegalArgumentException("Invalid path: " + path);
            }
            String segment = dot < 0 ? path : path.substring(0, dot);
            Accessor remainingAccessor = dot < 0 ? null : PropertyUtils.compilePathAccessor(path.substring(dot + 1));
            PathAccessor newAccessor = new PathAccessor(segment, remainingAccessor);
            Accessor existingAccessor = PATH_ACCESSORS.putIfAbsent(path, newAccessor);
            accessor = existingAccessor != null ? existingAccessor : newAccessor;
        }
        return accessor;
    }

    static Accessor getOrCreateSegmentAccessor(Class<?> objectClass, String propertyName) {
        Accessor a;
        ConcurrentHashMap<String, Accessor> forType = (ConcurrentHashMap<String, Accessor>)SEGMENT_ACCESSORS.get(objectClass);
        if (forType == null) {
            ConcurrentHashMap<String, Accessor> newPropAccessors = new ConcurrentHashMap<String, Accessor>();
            ConcurrentHashMap<String, Accessor> existingPropAccessors = SEGMENT_ACCESSORS.putIfAbsent(objectClass, newPropAccessors);
            ConcurrentHashMap<String, Accessor> concurrentHashMap = forType = existingPropAccessors != null ? existingPropAccessors : newPropAccessors;
        }
        if ((a = (Accessor)forType.get(propertyName)) == null) {
            Accessor newA = PropertyUtils.createSegmentAccessor(objectClass, propertyName);
            Accessor existingA = forType.putIfAbsent(propertyName, newA);
            a = existingA != null ? existingA : newA;
        }
        return a;
    }

    static Accessor createSegmentAccessor(Class<?> objectClass, String propertyName) {
        if (Map.class.isAssignableFrom(objectClass)) {
            return new MapAccessor(propertyName);
        }
        return accessorFactory.createAccessor(objectClass, propertyName, null);
    }

    public static Object getProperty(Object object, String nestedPropertyName) throws CayenneRuntimeException {
        return PropertyUtils.accessor(nestedPropertyName).getValue(object);
    }

    public static void setProperty(Object object, String nestedPropertyName, Object value) throws CayenneRuntimeException {
        PropertyUtils.accessor(nestedPropertyName).setValue(object, value);
    }

    static Class<?> normalizeType(Class<?> type) {
        if (type.isPrimitive()) {
            String className = type.getName();
            if ("byte".equals(className)) {
                return Byte.class;
            }
            if ("int".equals(className)) {
                return Integer.class;
            }
            if ("long".equals(className)) {
                return Long.class;
            }
            if ("short".equals(className)) {
                return Short.class;
            }
            if ("char".equals(className)) {
                return Character.class;
            }
            if ("double".equals(className)) {
                return Double.class;
            }
            if ("float".equals(className)) {
                return Float.class;
            }
            if ("boolean".equals(className)) {
                return Boolean.class;
            }
        }
        return type;
    }

    static Object defaultNullValueForType(Class<?> type) {
        if (type != null && type.isPrimitive()) {
            String className = type.getName();
            if ("byte".equals(className)) {
                return (byte)0;
            }
            if ("int".equals(className)) {
                return 0;
            }
            if ("long".equals(className)) {
                return 0L;
            }
            if ("short".equals(className)) {
                return (short)0;
            }
            if ("char".equals(className)) {
                return Character.valueOf('\u0000');
            }
            if ("double".equals(className)) {
                return 0.0;
            }
            if ("float".equals(className)) {
                return Float.valueOf(0.0f);
            }
            if ("boolean".equals(className)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static void installAccessorFactory(AccessorFactory accessorFactory) {
        PropertyUtils.accessorFactory = Objects.requireNonNull(accessorFactory);
    }

    private PropertyUtils() {
    }

    static final class PathAccessor
    implements Accessor {
        private static final long serialVersionUID = 2056090443413498626L;
        private final String segmentName;
        private final Accessor nextAccessor;

        public PathAccessor(String segmentName, Accessor nextAccessor) {
            this.segmentName = segmentName.endsWith("+") ? segmentName.substring(0, segmentName.length() - 1) : segmentName;
            this.nextAccessor = nextAccessor;
        }

        @Override
        public String getName() {
            return this.segmentName;
        }

        @Override
        public Object getValue(Object object) throws PropertyException {
            if (object == null) {
                return null;
            }
            Object value = PropertyUtils.getOrCreateSegmentAccessor(object.getClass(), this.segmentName).getValue(object);
            return this.nextAccessor != null ? this.nextAccessor.getValue(value) : value;
        }

        @Override
        public void setValue(Object object, Object newValue) throws PropertyException {
            if (object == null) {
                return;
            }
            Accessor segmentAccessor = PropertyUtils.getOrCreateSegmentAccessor(object.getClass(), this.segmentName);
            if (this.nextAccessor != null) {
                this.nextAccessor.setValue(segmentAccessor.getValue(object), newValue);
            } else {
                segmentAccessor.setValue(object, newValue);
            }
        }
    }
}

