/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.QueryDescriptorLoader;
import org.apache.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class QueryDescriptorHandler
extends NamespaceAwareNestedTagHandler {
    private static final String QUERY_DESCRIPTOR_TAG = "query";
    private static final String QUERY_SQL_TAG = "sql";
    private static final String QUERY_EJBQL_TAG = "ejbql";
    private static final String QUERY_QUALIFIER_TAG = "qualifier";
    private static final String QUERY_ORDERING_TAG = "ordering";
    private static final String QUERY_PREFETCH_TAG = "prefetch";
    public static final String PROPERTY_TAG = "property";
    private DataMap map;
    private QueryDescriptorLoader queryBuilder;
    private QueryDescriptor descriptor;
    private boolean changed;
    private String sqlKey;
    private String descending;
    private String ignoreCase;
    private int semantics;

    public QueryDescriptorHandler(NamespaceAwareNestedTagHandler parentHandler, DataMap map) {
        super(parentHandler);
        this.map = map;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "query": {
                this.addQueryDescriptor(attributes);
                return true;
            }
            case "property": {
                this.addQueryDescriptorProperty(attributes);
                return true;
            }
            case "sql": {
                this.sqlKey = attributes.getValue("adapter-class");
                return true;
            }
            case "ordering": {
                this.createQueryOrdering(attributes);
                return true;
            }
            case "ejbql": 
            case "qualifier": 
            case "prefetch": {
                this.createPrefetchSemantics(attributes);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void processCharData(String localName, String data) {
        switch (localName) {
            case "sql": {
                this.queryBuilder.addSql(data, this.sqlKey);
                break;
            }
            case "ejbql": {
                this.queryBuilder.setEjbql(data);
                break;
            }
            case "qualifier": {
                this.createQualifier(data);
                break;
            }
            case "ordering": {
                this.addQueryOrdering(data);
                break;
            }
            case "prefetch": {
                this.addPrefetchWithSemantics(data);
            }
        }
    }

    @Override
    protected void beforeScopeEnd() {
        this.map.addQueryDescriptor(this.getQueryDescriptor());
    }

    private void addQueryDescriptor(Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        if (null == name) {
            throw new SAXException("QueryDescriptorHandler::addQueryDescriptor() - no query name.");
        }
        this.queryBuilder = new QueryDescriptorLoader();
        this.queryBuilder.setName(name);
        String type = attributes.getValue("type");
        if (type == null) {
            this.queryBuilder.setLegacyFactory(attributes.getValue("factory"));
        } else {
            this.queryBuilder.setQueryType(type);
        }
        String rootName = attributes.getValue("root-name");
        this.queryBuilder.setRoot(this.map, attributes.getValue("root"), rootName);
        String resultEntity = attributes.getValue("result-entity");
        if (!Util.isEmptyString(resultEntity)) {
            this.queryBuilder.setResultEntity(resultEntity);
        }
        this.changed = true;
    }

    private void addQueryDescriptorProperty(Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        if (null == name) {
            throw new SAXException("QueryDescriptorHandler::addQueryDescriptorProperty() - no property name.");
        }
        String value = attributes.getValue("value");
        if (null == value) {
            throw new SAXException("QueryDescriptorHandler::addQueryDescriptorProperty() - no property value.");
        }
        this.queryBuilder.addProperty(name, value);
        this.changed = true;
    }

    private void createQualifier(String qualifier) {
        if (Util.isBlank(qualifier)) {
            return;
        }
        this.queryBuilder.setQualifier(qualifier);
        this.changed = true;
    }

    private void createQueryOrdering(Attributes attributes) {
        this.descending = attributes.getValue("descending");
        this.ignoreCase = attributes.getValue("ignore-case");
    }

    private void addQueryOrdering(String path) {
        this.queryBuilder.addOrdering(path, this.descending, this.ignoreCase);
        this.changed = true;
    }

    private void createPrefetchSemantics(Attributes attributes) {
        this.semantics = this.convertPrefetchType(attributes.getValue("type"));
    }

    private void addPrefetchWithSemantics(String path) {
        this.queryBuilder.addPrefetch(path, this.semantics);
    }

    public QueryDescriptor getQueryDescriptor() {
        if (this.queryBuilder == null) {
            return null;
        }
        if (this.descriptor == null || this.changed) {
            this.descriptor = this.queryBuilder.buildQueryDescriptor();
            this.changed = false;
        }
        return this.descriptor;
    }

    private int convertPrefetchType(String type) {
        if (type != null) {
            switch (type) {
                case "joint": {
                    return 1;
                }
                case "disjoint": {
                    return 2;
                }
                case "disjointById": {
                    return 3;
                }
            }
            return 0;
        }
        return 0;
    }
}

