/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.inflector;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.inflector.Pluralizer;
import org.jvnet.inflector.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBasedPluralizer
implements Pluralizer {
    private static final Pluralizer IDENTITY_PLURALIZER = new IdentityPluralizer();
    private List<Rule> rules;
    private Locale locale;
    private Pluralizer fallbackPluralizer;

    public RuleBasedPluralizer() {
        this(Collections.EMPTY_LIST, Locale.getDefault());
    }

    public RuleBasedPluralizer(List<Rule> rules, Locale locale) {
        this(rules, locale, IDENTITY_PLURALIZER);
    }

    public RuleBasedPluralizer(List<Rule> rules, Locale locale, Pluralizer fallbackPluralizer) {
        this.rules = rules;
        this.locale = locale;
        this.fallbackPluralizer = fallbackPluralizer;
    }

    public Pluralizer getFallbackPluralizer() {
        return this.fallbackPluralizer;
    }

    public void setFallbackPluralizer(Pluralizer fallbackPluralizer) {
        this.fallbackPluralizer = fallbackPluralizer;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    @Override
    public String pluralize(String word) {
        return this.pluralize(word, 2);
    }

    @Override
    public String pluralize(String word, int number) {
        if (number == 1) {
            return word;
        }
        Pattern pattern = Pattern.compile("\\A(\\s*)(.+?)(\\s*)\\Z");
        Matcher matcher = pattern.matcher(word);
        if (matcher.matches()) {
            String pre = matcher.group(1);
            String trimmedWord = matcher.group(2);
            String post = matcher.group(3);
            String plural = this.pluralizeInternal(trimmedWord);
            if (plural == null) {
                return this.fallbackPluralizer.pluralize(word, number);
            }
            return pre + this.postProcess(trimmedWord, plural) + post;
        }
        return word;
    }

    protected String pluralizeInternal(String word) {
        for (Rule rule : this.rules) {
            if (!rule.applies(word)) continue;
            return rule.apply(word);
        }
        return null;
    }

    protected String postProcess(String trimmedWord, String pluralizedWord) {
        if (trimmedWord.matches("^\\p{Lu}+$")) {
            return pluralizedWord.toUpperCase(this.locale);
        }
        if (trimmedWord.matches("^\\p{Lu}.*")) {
            return pluralizedWord.substring(0, 1).toUpperCase(this.locale) + pluralizedWord.substring(1);
        }
        return pluralizedWord;
    }

    static class IdentityPluralizer
    implements Pluralizer {
        IdentityPluralizer() {
        }

        public String pluralize(String word) {
            return word;
        }

        public String pluralize(String word, int number) {
            return word;
        }
    }
}

