/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.configuration2.builder.BasicBuilderProperties;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.DefaultParametersHandler;
import org.apache.commons.configuration2.builder.DefaultParametersManager;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDefaultParametersManager {
    private static final String DEF_ENCODING = StandardCharsets.UTF_8.name();
    private static ListDelimiterHandler listHandler;
    private Parameters parameters;
    private DefaultParametersManager manager;

    private static void checkDefaultValues(Map<String, Object> map) {
        Assertions.assertEquals((Object)listHandler, (Object)map.get("listDelimiterHandler"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)map.get("throwExceptionOnMissing"));
        FileBasedBuilderParametersImpl fbparams = FileBasedBuilderParametersImpl.fromParameters(map);
        Assertions.assertEquals((Object)DEF_ENCODING, (Object)fbparams.getFileHandler().getEncoding());
    }

    private static void checkNoDefaultValues(Map<String, Object> map) {
        Assertions.assertFalse((boolean)map.containsKey("throwExceptionOnMissing"));
        FileBasedBuilderParametersImpl fbParams = FileBasedBuilderParametersImpl.fromParameters(map, (boolean)true);
        Assertions.assertNull((Object)fbParams.getFileHandler().getEncoding());
    }

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        listHandler = (ListDelimiterHandler)Mockito.mock(ListDelimiterHandler.class);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.parameters = new Parameters();
        this.manager = new DefaultParametersManager();
    }

    @Test
    void testApplyDefaults() {
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)new FileBasedDefaultsHandler());
        FileBasedBuilderParameters params = this.parameters.fileBased();
        this.manager.initializeParameters((BuilderParameters)params);
        Map map = params.getParameters();
        TestDefaultParametersManager.checkDefaultValues(map);
    }

    @Test
    void testApplyDefaultsMultipleHandlers() {
        ExpressionEngine engine = (ExpressionEngine)Mockito.mock(ExpressionEngine.class);
        this.manager.registerDefaultsHandler(XMLBuilderParameters.class, parameters -> ((XMLBuilderParameters)((XMLBuilderParameters)parameters.setThrowExceptionOnMissing(false)).setListDelimiterHandler((ListDelimiterHandler)Mockito.mock(ListDelimiterHandler.class))).setExpressionEngine(engine));
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)new FileBasedDefaultsHandler());
        XMLBuilderParameters params = this.parameters.xml();
        this.manager.initializeParameters((BuilderParameters)params);
        Map map = params.getParameters();
        TestDefaultParametersManager.checkDefaultValues(map);
        Assertions.assertSame((Object)engine, map.get("expressionEngine"));
    }

    @Test
    void testApplyDefaultsOnSubClass() {
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)new FileBasedDefaultsHandler());
        XMLBuilderParameters params = this.parameters.xml();
        this.manager.initializeParameters((BuilderParameters)params);
        Map map = params.getParameters();
        TestDefaultParametersManager.checkDefaultValues(map);
    }

    @Test
    void testApplyDefaultsStartClass() {
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)new FileBasedDefaultsHandler(), XMLBuilderParameters.class);
        XMLBuilderParameters paramsXml = this.parameters.xml();
        this.manager.initializeParameters((BuilderParameters)paramsXml);
        Map map = paramsXml.getParameters();
        TestDefaultParametersManager.checkDefaultValues(map);
        PropertiesBuilderParameters paramsProps = this.parameters.properties();
        this.manager.initializeParameters((BuilderParameters)paramsProps);
        map = paramsProps.getParameters();
        TestDefaultParametersManager.checkNoDefaultValues(map);
    }

    @Test
    void testInitializeParametersNull() {
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)new FileBasedDefaultsHandler());
        this.manager.initializeParameters(null);
    }

    @Test
    void testRegisterDefaultsHandlerNoClass() {
        FileBasedDefaultsHandler handler = new FileBasedDefaultsHandler();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.manager.registerDefaultsHandler(null, (DefaultParametersHandler)handler));
    }

    @Test
    void testRegisterDefaultsHandlerNoHandler() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.manager.registerDefaultsHandler(BasicBuilderProperties.class, null));
    }

    @Test
    void testUnregisterDefaultsHandlerAll() {
        FileBasedDefaultsHandler handler = new FileBasedDefaultsHandler();
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)handler, XMLBuilderParameters.class);
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)handler, PropertiesBuilderParameters.class);
        this.manager.unregisterDefaultsHandler((DefaultParametersHandler)handler);
        XMLBuilderParameters paramsXml = this.parameters.xml();
        this.manager.initializeParameters((BuilderParameters)paramsXml);
        TestDefaultParametersManager.checkNoDefaultValues(paramsXml.getParameters());
        PropertiesBuilderParameters paramsProps = this.parameters.properties();
        this.manager.initializeParameters((BuilderParameters)paramsProps);
        TestDefaultParametersManager.checkNoDefaultValues(paramsProps.getParameters());
    }

    @Test
    void testUnregisterDefaultsHandlerSpecific() {
        FileBasedDefaultsHandler handler = new FileBasedDefaultsHandler();
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)handler, XMLBuilderParameters.class);
        this.manager.registerDefaultsHandler(FileBasedBuilderParameters.class, (DefaultParametersHandler)handler, PropertiesBuilderParameters.class);
        this.manager.unregisterDefaultsHandler((DefaultParametersHandler)handler, PropertiesBuilderParameters.class);
        XMLBuilderParameters paramsXml = this.parameters.xml();
        this.manager.initializeParameters((BuilderParameters)paramsXml);
        TestDefaultParametersManager.checkDefaultValues(paramsXml.getParameters());
        PropertiesBuilderParameters paramsProps = this.parameters.properties();
        this.manager.initializeParameters((BuilderParameters)paramsProps);
        TestDefaultParametersManager.checkNoDefaultValues(paramsProps.getParameters());
    }

    private static final class FileBasedDefaultsHandler
    implements DefaultParametersHandler<FileBasedBuilderParameters> {
        private FileBasedDefaultsHandler() {
        }

        public void initializeDefaults(FileBasedBuilderParameters parameters) {
            ((FileBasedBuilderParameters)((FileBasedBuilderParameters)parameters.setThrowExceptionOnMissing(true)).setEncoding(DEF_ENCODING)).setListDelimiterHandler(listHandler);
        }
    }
}

