/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.List;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointerFactory;
import org.apache.commons.configuration2.tree.xpath.XPathContextFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConfigurationNodePointerFactory
extends AbstractXPathTest {
    private JXPathContext context;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new ConfigurationNodePointerFactory());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context = new XPathContextFactory().createContext((Object)this.root, this.handler);
    }

    @Test
    void testFollowingSiblingAxis() {
        List nodes = this.context.selectNodes("/subNode[2]/following-sibling::*");
        Assertions.assertEquals((int)1, (int)nodes.size());
        ImmutableNode node = (ImmutableNode)nodes.get(0);
        Assertions.assertEquals((Object)"childNode", (Object)node.getNodeName());
        Assertions.assertEquals((Object)String.valueOf(5), (Object)node.getValue());
    }

    @Test
    void testIndices() {
        Assertions.assertEquals((Object)"1.2.3", (Object)this.context.getValue("/childNode[1]/subNode[1]/childNode[2]"));
        Assertions.assertEquals((Object)String.valueOf(5), (Object)this.context.getValue("childNode[last()]"));
        List nodes = this.context.selectNodes("/subNode[1]/*");
        Assertions.assertEquals((int)5, (int)nodes.size());
        int index = 1;
        for (ImmutableNode node : nodes) {
            Assertions.assertEquals((Object)("2." + index), (Object)node.getValue(), (String)("Wrong node value for child " + index));
            ++index;
        }
    }

    @Test
    void testParentAxis() {
        List nodes = this.context.selectNodes("/childNode/parent::*");
        Assertions.assertEquals((int)1, (int)nodes.size());
    }

    @Test
    void testPrecedingSiblingAxis() {
        List nodes = this.context.selectNodes("/subNode[2]/preceding-sibling::*");
        Assertions.assertEquals((int)3, (int)nodes.size());
        int index = 0;
        int value = 3;
        while (index < nodes.size()) {
            Assertions.assertEquals((Object)String.valueOf(value), (Object)((ImmutableNode)nodes.get(index)).getValue());
            ++index;
            --value;
        }
    }

    @Test
    void testQueryAttribute() {
        Assertions.assertEquals((Object)"1", (Object)this.context.getValue("/childNode[1]/@counter"));
    }

    @Test
    void testQueryRootAttribute() {
        Assertions.assertEquals((Object)"true", (Object)this.context.getValue("@rootAttr"));
    }

    @Test
    void testSimpleXPath() {
        List results = this.context.selectNodes("subNode");
        Assertions.assertEquals((int)2, (int)results.size());
        for (Object result : results) {
            ImmutableNode node = (ImmutableNode)result;
            Assertions.assertEquals((Object)"subNode", (Object)node.getNodeName());
        }
        results = this.context.selectNodes("/subNode");
        Assertions.assertEquals((int)2, (int)results.size());
        results = this.context.selectNodes("childNode/subNode/childNode");
        Assertions.assertEquals((int)18, (int)results.size());
    }

    @Test
    void testText() {
        List nodes = this.context.selectNodes("//childNode[text()='1.1.1']");
        Assertions.assertEquals((int)1, (int)nodes.size());
    }
}

