/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.TestArguments;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class CountersTest
extends TestArguments {
    CountersTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"numberCounters"})
    void testInitialValue(Counters.Counter counter) {
        CounterAssertions.assertCounter(0L, counter, "");
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    void testInitialValues(Counters.PathCounters pathCounter) {
        CounterAssertions.assertCounts(0L, 0L, 0L, pathCounter);
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    void testResetCounter(Counters.PathCounters pathCounter) {
        Counters.Counter byteCounter = pathCounter.getByteCounter();
        long old = byteCounter.get();
        byteCounter.add(1L);
        Assertions.assertEquals((long)(old + 1L), (long)byteCounter.get());
        byteCounter.reset();
        Assertions.assertEquals((long)0L, (long)byteCounter.get());
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    void testResetPathCounter(Counters.PathCounters pathCounter) {
        Counters.Counter byteCounter = pathCounter.getByteCounter();
        long old = byteCounter.get();
        byteCounter.add(1L);
        Assertions.assertEquals((long)(old + 1L), (long)byteCounter.get());
        pathCounter.reset();
        Assertions.assertEquals((long)0L, (long)byteCounter.get());
    }

    @ParameterizedTest
    @MethodSource(value={"numberCounters"})
    void testToString(Counters.Counter counter) {
        counter.toString();
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    void testToString(Counters.PathCounters pathCounter) {
        pathCounter.toString();
    }
}

