/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.function.IOSupplier;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.api.RatException;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.report.xml.XmlReportFactory;
import org.apache.rat.report.xml.writer.XmlWriter;
import org.w3c.dom.Document;

public class Reporter {
    private static final String LICENSE_FORMAT = "%s:\t%s%n\t\t%s%n";
    private Document document;
    private ClaimStatistic statistic;
    private final ReportConfiguration configuration;

    public Reporter(ReportConfiguration configuration) {
        this.configuration = configuration;
    }

    public ClaimStatistic execute() throws RatException {
        block9: {
            if (this.document == null || this.statistic == null) {
                try {
                    if (this.configuration.hasSource()) {
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
                        try (XmlWriter writer = new XmlWriter(outputWriter);){
                            this.statistic = new ClaimStatistic();
                            RatReport report = XmlReportFactory.createStandardReport(writer, this.statistic, this.configuration);
                            report.startReport();
                            this.configuration.getSources().build().run(report);
                            report.endReport();
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
                            break block9;
                        }
                    }
                    this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    this.statistic = new ClaimStatistic();
                }
                catch (Exception e) {
                    throw RatException.makeRatException(e);
                }
            }
        }
        return this.statistic;
    }

    public ClaimStatistic getClaimsStatistic() {
        return this.statistic;
    }

    public ClaimStatistic output() throws RatException {
        return this.output(this.configuration.getStyleSheet(), this.configuration.getOutput());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ClaimStatistic output(IOSupplier<InputStream> stylesheet, IOSupplier<OutputStream> output) throws RatException {
        ClaimStatistic result = this.execute();
        TransformerFactory tf = TransformerFactory.newInstance();
        try (OutputStream out = output.get();){
            ClaimStatistic claimStatistic;
            block14: {
                InputStream styleIn = stylesheet.get();
                try {
                    Transformer transformer = tf.newTransformer(new StreamSource(styleIn));
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    transformer.transform(new DOMSource(this.document), new StreamResult(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
                    claimStatistic = result;
                    if (styleIn == null) break block14;
                }
                catch (Throwable throwable) {
                    if (styleIn != null) {
                        try {
                            styleIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                styleIn.close();
            }
            return claimStatistic;
        }
        catch (IOException | TransformerException e) {
            throw new RatException(e);
        }
    }

    public static void listLicenses(ReportConfiguration configuration, LicenseSetFactory.LicenseFilter filter) throws IOException {
        try (PrintWriter pw = configuration.getWriter().get();){
            pw.format("Licenses (%s):%n", new Object[]{filter});
            configuration.getLicenses(filter).forEach(lic -> pw.format(LICENSE_FORMAT, lic.getLicenseFamily().getFamilyCategory(), lic.getLicenseFamily().getFamilyName(), lic.getNote()));
            pw.println();
        }
    }

    public void writeSummary(Appendable appendable) throws IOException {
        appendable.append("RAT summary:").append(System.lineSeparator());
        for (ClaimStatistic.Counter counter : ClaimStatistic.Counter.values()) {
            appendable.append("  ").append(counter.displayName()).append(":  ").append(Integer.toString(this.getClaimsStatistic().getCounter(counter))).append(System.lineSeparator());
        }
    }

    public Document getDocument() {
        return this.document;
    }
}

