/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.ctakes.utils.wiki;

import org.apache.lucene.search.similarities.ClassicSimilarity;


public class ApproximateSimilarity extends ClassicSimilarity {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	
	@Override
	public final float idf(long docFreq, long numDocs){
		return (float)ApproximateMath.alog(numDocs / (docFreq+1.0))+1; 
	}
	
	/* according to lucene javadocs, DefaultSimilarity.tf is simply a square root -- we can approximate with an
	 * array of pre-calculated square roots to save time
	 */
	public final float tf(int termFreq){
		return (float) ApproximateMath.asqrt(termFreq);
	}
}
