/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cxf.ws.transfer.dialect.fragment;

/**
 * Helper class for holding of constants.
 */
public final class FragmentDialectConstants {

    public static final String FRAGMENT_2011_03_IRI = "http://www.w3.org/2011/03/ws-fra";

    public static final String QNAME_LANGUAGE_IRI = "http://www.w3.org/2011/03/ws-fra/QName";

    public static final String XPATH10_LANGUAGE_IRI = "http://www.w3.org/2011/03/ws-fra/XPath10";

    public static final String FRAGMENT_TEXT_NODE_NAME = "TextNode";

    public static final String FRAGMENT_ATTR_NODE_NAME = "AttributeNode";

    public static final String FRAGMENT_ATTR_NODE_NAME_ATTR = "name";

    public static final String FRAGMENT_MODE_REPLACE = "http://www.w3.org/2011/03/ws-fra/Modes/Replace";

    public static final String FRAGMENT_MODE_ADD = "http://www.w3.org/2011/03/ws-fra/Modes/Add";

    public static final String FRAGMENT_MODE_INSERT_BEFORE = "http://www.w3.org/2011/03/ws-fra/Modes/InsertBefore";

    public static final String FRAGMENT_MODE_INSERT_AFTER = "http://www.w3.org/2011/03/ws-fra/Modes/InsertAfter";

    public static final String FRAGMENT_MODE_REMOVE = "http://www.w3.org/2011/03/ws-fra/Modes/Remove";

    private FragmentDialectConstants() {

    }
}
