/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.AbstractAcceptingSslChannel;
import org.xnio.ssl.JsseSslConnection;
import org.xnio.ssl.JsseSslStreamConnection;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.SslConnection;

final class JsseAcceptingSslStreamConnection
extends AbstractAcceptingSslChannel<SslConnection, StreamConnection> {
    JsseAcceptingSslStreamConnection(SSLContext sslContext, AcceptingChannel<? extends StreamConnection> tcpServer, OptionMap optionMap, Pool<ByteBuffer> socketBufferPool, Pool<ByteBuffer> applicationBufferPool, boolean startTls) {
        super(sslContext, tcpServer, optionMap, socketBufferPool, applicationBufferPool, startTls);
    }

    @Override
    public SslConnection accept(StreamConnection tcpConnection, SSLEngine engine) throws IOException {
        if (!JsseXnioSsl.NEW_IMPL) {
            return new JsseSslStreamConnection(tcpConnection, engine, this.socketBufferPool, this.applicationBufferPool, this.startTls);
        }
        JsseSslConnection connection = new JsseSslConnection(tcpConnection, engine, this.socketBufferPool, this.applicationBufferPool);
        if (!this.startTls) {
            try {
                connection.startHandshake();
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)connection);
                throw e;
            }
        }
        return connection;
    }
}

