/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.regex.Matcher;
import org.apache.daffodil.io.DataInputStream;
import org.apache.daffodil.io.DataInputStream$NotEnoughDataException$;
import org.apache.daffodil.io.DataInputStreamImplMixin;
import org.apache.daffodil.io.DataStreamCommonImplMixin;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSource;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.io.InputSourceDataInputStreamCharIterator;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.io.MarkPool;
import org.apache.daffodil.io.MarkState;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder$LeastSignificantBitFirst$;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder$MostSignificantBitFirst$;
import org.apache.daffodil.lib.schema.annotation.props.gen.ByteOrder;
import org.apache.daffodil.lib.schema.annotation.props.gen.ByteOrder$LittleEndian$;
import org.apache.daffodil.lib.util.Bits$;
import org.apache.daffodil.lib.util.LocalStack;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.lib.util.ThreadSafePool;
import passera.unsigned.ULong$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public final class InputSourceDataInputStream
implements org.apache.daffodil.api.InputSourceDataInputStream,
DataInputStream,
DataStreamCommonImplMixin,
LocalBufferMixin,
DataInputStreamImplMixin {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(InputSourceDataInputStream.class.getDeclaredField("withLocalByteBuffer$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(InputSourceDataInputStream.class.getDeclaredField("withLocalCharBuffer$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(InputSourceDataInputStream.class.getDeclaredField("skipCharBuffer$lzy1"));
    private volatile Object withLocalCharBuffer$lzy1;
    private volatile Object withLocalByteBuffer$lzy1;
    private final InputSource inputSource;
    private final MarkState cst;
    private final MStackOf markStack;
    private final MarkPool markPool;
    private final byte[] longArray;
    private volatile Object skipCharBuffer$lzy1;
    private final InputSourceDataInputStreamCharIterator charIterator;

    public static InputSourceDataInputStream apply(ByteBuffer byteBuffer) {
        return InputSourceDataInputStream$.MODULE$.apply(byteBuffer);
    }

    public static InputSourceDataInputStream apply(byte[] byArray) {
        return InputSourceDataInputStream$.MODULE$.apply(byArray);
    }

    public static InputSourceDataInputStream apply(InputStream inputStream) {
        return InputSourceDataInputStream$.MODULE$.apply(inputStream);
    }

    public InputSourceDataInputStream(InputSource inputSource) {
        this.inputSource = inputSource;
        LocalBufferMixin.$init$(this);
        this.cst = new MarkState();
        this.markStack = new MStackOf();
        this.markPool = new MarkPool();
        this.longArray = new byte[8];
        this.charIterator = new InputSourceDataInputStreamCharIterator(this);
    }

    public final LocalStack withLocalCharBuffer() {
        Object object = this.withLocalCharBuffer$lzy1;
        if (object instanceof LocalStack) {
            return (LocalStack)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LocalStack)this.withLocalCharBuffer$lzyINIT1();
    }

    private Object withLocalCharBuffer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.withLocalCharBuffer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LocalStack localStack = null;
                    try {
                        localStack = LocalBufferMixin.withLocalCharBuffer$(this);
                        object2 = localStack == null ? LazyVals.NullValue$.MODULE$ : localStack;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.withLocalCharBuffer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return localStack;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final LocalStack withLocalByteBuffer() {
        Object object = this.withLocalByteBuffer$lzy1;
        if (object instanceof LocalStack) {
            return (LocalStack)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LocalStack)this.withLocalByteBuffer$lzyINIT1();
    }

    private Object withLocalByteBuffer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.withLocalByteBuffer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LocalStack localStack = null;
                    try {
                        localStack = LocalBufferMixin.withLocalByteBuffer$(this);
                        object2 = localStack == null ? LazyVals.NullValue$.MODULE$ : localStack;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.withLocalByteBuffer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return localStack;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public InputSource inputSource() {
        return this.inputSource;
    }

    public String toString() {
        long bp0b = this.bitPos0b();
        long bl0b = this.bitLimit0b();
        String bl0b1 = MaybeULong$.MODULE$.isDefined$extension(bl0b) ? BoxesRunTime.boxToLong((long)MaybeULong$.MODULE$.get$extension(bl0b)).toString() : "none";
        String str = "DataInputStream(bitPos=" + bp0b + ", bitLimit=" + bl0b1 + ")";
        return str;
    }

    @Override
    public final MarkState cst() {
        return this.cst;
    }

    public MStackOf<MarkState> markStack() {
        return this.markStack;
    }

    public MarkPool markPool() {
        return this.markPool;
    }

    @Override
    public void close() {
        this.inputSource().close();
    }

    @Override
    public final long bitPos0b() {
        return this.cst().bitPos0b();
    }

    @Override
    public final long bitLimit0b() {
        return this.cst().bitLimit0b();
    }

    public boolean hasReachedEndOfData() {
        return this.inputSource().hasReachedEndOfData();
    }

    public long knownBytesAvailable() {
        return this.inputSource().knownBytesAvailable();
    }

    public void setBitPos0b(long newBitPos0b) {
        if (newBitPos0b < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitPos0b.>=(0)");
        }
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            throw Assert$.MODULE$.abort("Invariant broken: InputSourceDataInputStream.this.bitLimit0b.isEmpty.||(newBitPos0b.<=(InputSourceDataInputStream.this.bitLimit0b.get))");
        }
        this.inputSource().position(newBitPos0b >> 3);
        this.cst().bitPos0b_$eq(newBitPos0b);
    }

    @Override
    public boolean setBitLimit0b(long newBitLimit0b) {
        if (!MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) && MaybeULong$.MODULE$.get$extension(newBitLimit0b) < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitLimit0b.isEmpty.||(newBitLimit0b.get.>=(0))");
        }
        if (MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) || MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) || MaybeULong$.MODULE$.get$extension(newBitLimit0b) <= MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            this.cst().bitLimit0b_$eq(newBitLimit0b);
            return true;
        }
        return false;
    }

    @Override
    public void resetBitLimit0b(long savedBitLimit0b) {
        this.cst().bitLimit0b_$eq(savedBitLimit0b);
    }

    @Override
    public byte[] getByteArray(int bitLengthFrom1, FormatInfo finfo) {
        if (!this.isDefinedForLength(Int$.MODULE$.int2long(bitLengthFrom1))) {
            throw DataInputStream$NotEnoughDataException$.MODULE$.apply(Int$.MODULE$.int2long(bitLengthFrom1));
        }
        int arraySize = (bitLengthFrom1 + 7) / 8;
        byte[] array = new byte[arraySize];
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
        return array;
    }

    @Override
    public void getByteArray(int bitLengthFrom1, FormatInfo finfo, byte[] array) {
        if (!this.isDefinedForLength(Int$.MODULE$.int2long(bitLengthFrom1))) {
            throw DataInputStream$NotEnoughDataException$.MODULE$.apply(Int$.MODULE$.int2long(bitLengthFrom1));
        }
        int bytesNeeded = (bitLengthFrom1 + 7) / 8;
        Object object = Predef$.MODULE$.byteArrayOps(array);
        if (ArrayOps$.MODULE$.size$extension(object) < bytesNeeded) {
            throw Assert$.MODULE$.usageError("scala.Predef.byteArrayOps(array).size.>=(bytesNeeded)");
        }
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
    }

    private void fillByteArray(byte[] array, int bitLengthFrom1, FormatInfo finfo) {
        boolean isUnaligned = !this.isAligned(8);
        int fragmentBits = bitLengthFrom1 % 8;
        int bytesToFill = (bitLengthFrom1 + 7) / 8;
        this.inputSource().get(array, 0, bytesToFill);
        if (isUnaligned) {
            int index;
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder$MostSignificantBitFirst$ bitOrder$MostSignificantBitFirst$ = BitOrder$MostSignificantBitFirst$.MODULE$;
            boolean isMSBF = !(bitOrder != null ? !bitOrder.equals(bitOrder$MostSignificantBitFirst$) : bitOrder$MostSignificantBitFirst$ != null);
            int bitOffset0b = (int)(this.bitPos0b() % 8L);
            int bytesToRead = (bitLengthFrom1 + bitOffset0b + 7) / 8;
            int arrayOverflow = bytesToRead > bytesToFill ? Bits$.MODULE$.asUnsignedByte(Int$.MODULE$.int2long(this.inputSource().get())) : 0;
            int curBitMask = isMSBF ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(8 - bitOffset0b)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(8 - bitOffset0b));
            int nxtBitMask = ~curBitMask & 0xFF;
            int curShift = bitOffset0b;
            int nxtShift = 8 - bitOffset0b;
            int curByte = Bits$.MODULE$.asUnsignedByte(array[index]);
            int stopIndex = bytesToFill - 1;
            for (index = 0; index < stopIndex; ++index) {
                int nxtByte = Bits$.MODULE$.asUnsignedByte(array[index + 1]);
                array[index] = InputSourceDataInputStream.calcNewByte$1(curBitMask, nxtBitMask, isMSBF, curShift, nxtShift, Int$.MODULE$.int2long(curByte), Int$.MODULE$.int2long(nxtByte));
                curByte = nxtByte;
            }
            array[index] = InputSourceDataInputStream.calcNewByte$1(curBitMask, nxtBitMask, isMSBF, curShift, nxtShift, Int$.MODULE$.int2long(curByte), Int$.MODULE$.int2long(arrayOverflow));
        }
        if (fragmentBits > 0) {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder$MostSignificantBitFirst$ bitOrder$MostSignificantBitFirst$ = BitOrder$MostSignificantBitFirst$.MODULE$;
            int mask = !(bitOrder != null ? !bitOrder.equals(bitOrder$MostSignificantBitFirst$) : bitOrder$MostSignificantBitFirst$ != null) ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(fragmentBits)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(fragmentBits));
            int lastIndex = bytesToFill - 1;
            int lastByte = Bits$.MODULE$.asUnsignedByte(array[lastIndex]);
            array[lastIndex] = Bits$.MODULE$.asSignedByte(Int$.MODULE$.int2long(lastByte & mask));
        }
        if (bitLengthFrom1 > 8) {
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder$LittleEndian$ byteOrder$LittleEndian$ = ByteOrder$LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(byteOrder$LittleEndian$) : byteOrder$LittleEndian$ != null)) {
                Bits$.MODULE$.reverseBytes(array, bytesToFill);
                return;
            }
        }
    }

    @Override
    public double getBinaryDouble(FormatInfo finfo) {
        long l = this.getSignedLong(64, finfo);
        double d = Double.longBitsToDouble(l);
        return d;
    }

    @Override
    public float getBinaryFloat(FormatInfo finfo) {
        int i = (int)this.getSignedLong(32, finfo);
        float f = Float.intBitsToFloat(i);
        return f;
    }

    @Override
    public long getSignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.usageError("bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.usageError("bitLengthFrom1To64.<=(64)");
        }
        long res = this.getUnsignedLong(bitLengthFrom1To64, finfo);
        return Bits$.MODULE$.signExtend(res, bitLengthFrom1To64);
    }

    @Override
    public long getUnsignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        long l;
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.usageError("bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.usageError("bitLengthFrom1To64.<=(64)");
        }
        if (!this.isDefinedForLength(Int$.MODULE$.int2long(bitLengthFrom1To64))) {
            throw DataInputStream$NotEnoughDataException$.MODULE$.apply(Int$.MODULE$.int2long(bitLengthFrom1To64));
        }
        int numBytes = (bitLengthFrom1To64 + 7) / 8;
        this.fillByteArray(this.longArray, bitLengthFrom1To64, finfo);
        int fragmentLength = bitLengthFrom1To64 % 8;
        if (fragmentLength == 0) {
            long l2;
            l = l2 = this.buildLongFromArray$1(numBytes);
        } else {
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder$LittleEndian$ byteOrder$LittleEndian$ = ByteOrder$LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(byteOrder$LittleEndian$) : byteOrder$LittleEndian$ != null)) {
                long l3;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder$MostSignificantBitFirst$ bitOrder$MostSignificantBitFirst$ = BitOrder$MostSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(bitOrder$MostSignificantBitFirst$) : bitOrder$MostSignificantBitFirst$ != null)) {
                    int firstByte = Bits$.MODULE$.asUnsignedByte(this.longArray[0]);
                    int shifted = firstByte >>> 8 - fragmentLength;
                    this.longArray[0] = Bits$.MODULE$.asSignedByte(Int$.MODULE$.int2long(shifted));
                }
                l = l3 = this.buildLongFromArray$1(numBytes);
            } else {
                long l4;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder$LeastSignificantBitFirst$ bitOrder$LeastSignificantBitFirst$ = BitOrder$LeastSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(bitOrder$LeastSignificantBitFirst$) : bitOrder$LeastSignificantBitFirst$ != null)) {
                    int lastIndex = numBytes - 1;
                    byte lastByte = this.longArray[lastIndex];
                    int shifted = lastByte << 8 - fragmentLength;
                    this.longArray[lastIndex] = Bits$.MODULE$.asSignedByte(Int$.MODULE$.int2long(shifted));
                }
                long unShiftedLong = this.buildLongFromArray$1(numBytes);
                l = l4 = unShiftedLong >>> 8 - fragmentLength;
            }
        }
        long res = l;
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1To64);
        return ULong$.MODULE$.apply(res);
    }

    private void adjustBigIntArrayWithFragmentByte(byte[] array, int fragmentLength, FormatInfo finfo) {
        ByteOrder byteOrder = finfo.byteOrder();
        ByteOrder$LittleEndian$ byteOrder$LittleEndian$ = ByteOrder$LittleEndian$.MODULE$;
        if (!(byteOrder != null ? !byteOrder.equals(byteOrder$LittleEndian$) : byteOrder$LittleEndian$ != null)) {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder$MostSignificantBitFirst$ bitOrder$MostSignificantBitFirst$ = BitOrder$MostSignificantBitFirst$.MODULE$;
            if (!(bitOrder != null ? !bitOrder.equals(bitOrder$MostSignificantBitFirst$) : bitOrder$MostSignificantBitFirst$ != null)) {
                int firstByte = Bits$.MODULE$.asUnsignedByte(array[0]);
                int shifted = firstByte >>> 8 - fragmentLength;
                array[0] = Bits$.MODULE$.asSignedByte(Int$.MODULE$.int2long(shifted));
                return;
            }
            return;
        }
        BitOrder bitOrder = finfo.bitOrder();
        BitOrder$LeastSignificantBitFirst$ bitOrder$LeastSignificantBitFirst$ = BitOrder$LeastSignificantBitFirst$.MODULE$;
        if (!(bitOrder != null ? !bitOrder.equals(bitOrder$LeastSignificantBitFirst$) : bitOrder$LeastSignificantBitFirst$ != null)) {
            int lastIndex = array.length - 1;
            byte lastByte = array[lastIndex];
            int shifted = lastByte << 8 - fragmentLength;
            array[lastIndex] = Bits$.MODULE$.asSignedByte(Int$.MODULE$.int2long(shifted));
        }
        ByteBuffer bb = ByteBuffer.wrap(array);
        Bits$.MODULE$.shiftRight(bb, 8 - fragmentLength);
    }

    @Override
    public BigInteger getSignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.usageError("bitLengthFrom1.>=(1)");
        }
        if (bitLengthFrom1 <= 64) {
            return BigInteger.valueOf(this.getSignedLong(bitLengthFrom1, finfo));
        }
        byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
        int fragmentLength = bitLengthFrom1 % 8;
        if (fragmentLength > 0) {
            this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
            int shift = 8 - fragmentLength;
            bytes[0] = (byte)((byte)(bytes[0] << shift) >> shift);
        }
        return new BigInteger(bytes);
    }

    @Override
    public BigInteger getUnsignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.usageError("bitLengthFrom1.>=(1)");
        }
        byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
        int fragmentLength = bitLengthFrom1 % 8;
        if (fragmentLength > 0) {
            this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
        }
        return new BigInteger(1, bytes);
    }

    @Override
    public final boolean isDefinedForLength(long nBits) {
        long newBitPos0b = this.bitPos0b() + nBits;
        if (MaybeULong$.MODULE$.isDefined$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            return false;
        }
        long newEndingBytePos0b = Bits$.MODULE$.roundUpBitToBytePosition(newBitPos0b);
        long moreBytesNeeded = newEndingBytePos0b - this.inputSource().position();
        return this.inputSource().areBytesAvailable(moreBytesNeeded);
    }

    @Override
    public final boolean hasData() {
        return this.isDefinedForLength(1L);
    }

    @Override
    public boolean skip(long nBits, FormatInfo finfo) {
        if (!this.isDefinedForLength(nBits)) {
            return false;
        }
        this.setBitPos0b(this.bitPos0b() + nBits);
        return true;
    }

    @Override
    public DataInputStream.Mark mark(String requestorID) {
        MarkState m = (MarkState)this.markPool().getFromPool(requestorID);
        m.assignFrom(this.cst());
        this.markStack().push(m);
        this.inputSource().lockPosition(m.bytePos0b());
        return m;
    }

    private MarkState releaseUntilMark(DataInputStream.Mark mark) {
        if (this.markStack().isEmpty()) {
            throw Assert$.MODULE$.usageError("InputSourceDataInputStream.this.markStack.isEmpty.unary_!");
        }
        if (mark == null) {
            throw Assert$.MODULE$.usageError("mark.!=(null)");
        }
        MarkState current = this.markStack().pop();
        while (!this.markStack().isEmpty() && current != mark) {
            this.inputSource().releasePosition(current.bytePos0b());
            this.markPool().returnToPool(current);
            current = this.markStack().pop();
        }
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        return current;
    }

    @Override
    public void reset(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.cst().assignFrom(current);
        this.setBitPos0b(this.cst().bitPos0b());
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public void discard(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public long markPos() {
        return this.bitPos0b();
    }

    @Override
    public void resetPos(long m) {
        this.setBitPos0b(m);
    }

    public void validateFinalStreamState() {
        this.markPool().finalCheck();
    }

    @Override
    public final Object getSomeString(long nChars, FormatInfo finfo) {
        long startingBitPos = this.bitPos0b();
        Object r = this.withLocalCharBuffer().apply((Function1 & Serializable)lcb -> new Maybe(this.getSomeString$$anonfun$1(nChars, finfo, startingBitPos, (LocalBufferMixin.LocalCharBuffer)lcb)));
        if (r == null) {
            return null;
        }
        return ((Maybe)r).v();
    }

    public CharBuffer skipCharBuffer() {
        Object object = this.skipCharBuffer$lzy1;
        if (object instanceof CharBuffer) {
            return (CharBuffer)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CharBuffer)this.skipCharBuffer$lzyINIT1();
    }

    private Object skipCharBuffer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.skipCharBuffer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CharBuffer charBuffer = null;
                    try {
                        charBuffer = CharBuffer.allocate(32);
                        object2 = charBuffer == null ? LazyVals.NullValue$.MODULE$ : charBuffer;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.skipCharBuffer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return charBuffer;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean skipChars(long nChars, FormatInfo finfo) {
        boolean skippedAllNChars;
        long remainingCharsToSkip;
        int numDecoded;
        long startingBitPos = this.bitPos0b();
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        if (!aligned) {
            return false;
        }
        boolean keepGoing = true;
        for (remainingCharsToSkip = nChars; keepGoing && remainingCharsToSkip > 0L; remainingCharsToSkip -= (long)numDecoded) {
            long charsToSkip = Math.min(remainingCharsToSkip, Int$.MODULE$.int2long(this.skipCharBuffer().capacity()));
            this.skipCharBuffer().position(0);
            this.skipCharBuffer().limit((int)charsToSkip);
            BitsCharsetDecoder bitsCharsetDecoder = finfo.decoder();
            numDecoded = bitsCharsetDecoder.decode(this, finfo, this.skipCharBuffer(), bitsCharsetDecoder.decode$default$4());
            if (numDecoded != 0) continue;
            keepGoing = false;
        }
        boolean bl = skippedAllNChars = remainingCharsToSkip == 0L;
        if (!skippedAllNChars) {
            this.setBitPos0b(startingBitPos);
        }
        return skippedAllNChars;
    }

    @Override
    public boolean lookingAt(Matcher matcher, FormatInfo finfo) {
        boolean bl;
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        if (!aligned) {
            return false;
        }
        ThreadSafePool<Tuple2<CharBuffer, LongBuffer>> ThreadSafePool_this = finfo.regexMatchStatePool();
        Tuple2<CharBuffer, LongBuffer> polled = ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$queue().poll();
        Tuple2<CharBuffer, LongBuffer> inst = polled == null ? ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$allocate() : polled;
        try {
            int regexMatchBufferLimit = finfo.tunable().initialRegexMatchLimitInCharacters();
            CharBuffer regexMatchBuffer = (CharBuffer)inst._1();
            LongBuffer regexMatchBitPositionBuffer = (LongBuffer)inst._2();
            regexMatchBuffer.position(0);
            regexMatchBuffer.limit(0);
            regexMatchBitPositionBuffer.position(0);
            regexMatchBitPositionBuffer.limit(0);
            long startingBitPos = this.bitPos0b();
            boolean keepMatching = true;
            boolean isMatch = false;
            while (keepMatching) {
                regexMatchBuffer.position(regexMatchBuffer.limit());
                regexMatchBuffer.limit(regexMatchBufferLimit);
                regexMatchBitPositionBuffer.position(regexMatchBitPositionBuffer.limit());
                regexMatchBitPositionBuffer.limit(regexMatchBufferLimit);
                int numDecoded = finfo.decoder().decode(this, finfo, regexMatchBuffer, regexMatchBitPositionBuffer);
                boolean potentiallyMoreData = regexMatchBuffer.position() == regexMatchBuffer.limit();
                regexMatchBuffer.flip();
                regexMatchBitPositionBuffer.flip();
                if (numDecoded > 0) {
                    matcher.reset(regexMatchBuffer);
                    isMatch = matcher.lookingAt();
                    boolean hitEnd = matcher.hitEnd();
                    boolean requireEnd = matcher.requireEnd();
                    if (potentiallyMoreData && (hitEnd || isMatch && requireEnd)) {
                        if (regexMatchBufferLimit == regexMatchBuffer.capacity()) {
                            keepMatching = false;
                            continue;
                        }
                        regexMatchBufferLimit = Math.min(regexMatchBufferLimit * 2, regexMatchBuffer.capacity());
                        continue;
                    }
                    keepMatching = false;
                    continue;
                }
                keepMatching = false;
            }
            if (isMatch && matcher.end() != 0) {
                long endingBitPos = regexMatchBitPositionBuffer.get(matcher.end() - 1);
                this.setBitPos0b(endingBitPos);
            } else {
                this.setBitPos0b(startingBitPos);
            }
            bl = isMatch;
        }
        finally {
            ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$queue().offer(inst);
        }
        return bl;
    }

    @Override
    public DataInputStream.CharIterator asIteratorChar() {
        InputSourceDataInputStreamCharIterator ci = this.charIterator;
        ci.reset();
        return ci;
    }

    @Override
    public void setDebugging(boolean setting) {
        DataInputStreamImplMixin.setDebugging$(this, setting);
        this.inputSource().setDebugging(setting);
    }

    @Override
    public ByteBuffer pastData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.usageError("nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        int bytesToRead = (int)Math.min(savedBytePosition, Int$.MODULE$.int2long(nBytesRequested));
        long newBytePosition = savedBytePosition - (long)bytesToRead;
        this.inputSource().position(newBytePosition);
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer futureData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.usageError("nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        boolean available = this.inputSource().areBytesAvailable(Int$.MODULE$.int2long(nBytesRequested));
        int bytesToRead = available ? nBytesRequested : (int)this.inputSource().knownBytesAvailable();
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    private static final byte calcNewByte$1(int curBitMask$1, int nxtBitMask$1, boolean isMSBF$1, int curShift$1, int nxtShift$1, long curByte, long nxtByte) {
        long curBits = curByte & (long)curBitMask$1;
        long nxtBits = nxtByte & (long)nxtBitMask$1;
        long newByte = isMSBF$1 ? curBits << curShift$1 | nxtBits >> nxtShift$1 : curBits >> curShift$1 | nxtBits << nxtShift$1;
        return Bits$.MODULE$.asSignedByte(newByte);
    }

    private final long buildLongFromArray$1(int numBytes$1) {
        long l = Int$.MODULE$.int2long(Bits$.MODULE$.asUnsignedByte(this.longArray[0]));
        for (int i = 1; i < numBytes$1; ++i) {
            l = l << 8 | (long)Bits$.MODULE$.asUnsignedByte(this.longArray[i]);
        }
        return l;
    }

    private final /* synthetic */ Object getSomeString$$anonfun$1(long nChars$1, FormatInfo finfo$1, long startingBitPos$1, LocalBufferMixin.LocalCharBuffer lcb) {
        CharBuffer cb = (CharBuffer)lcb.getBuf(nChars$1);
        BitsCharsetDecoder bitsCharsetDecoder = finfo$1.decoder();
        int numDecoded = bitsCharsetDecoder.decode(this, finfo$1, cb, bitsCharsetDecoder.decode$default$4());
        if (numDecoded > 0) {
            return Maybe$.MODULE$.apply(cb.flip().toString());
        }
        this.setBitPos0b(startingBitPos$1);
        return Maybe$.MODULE$.Nope();
    }
}

