/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.source.ModelNodeFactory;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementNodePointerFactory;
import org.apache.torque.generator.source.SourcePathPointer;

public final class SourcePath {
    private static final String PATH_LEVEL_SEPARATOR = "/";
    private static final String THIS_TOKEN = ".";
    private static final String PARENT_TOKEN = "..";
    private static final String ANY_ELEMENT_TOKEN = "*";

    private SourcePath() {
    }

    public static boolean hasChild(SourceElement sourceElement, String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (sourceElement == null) {
            throw new NullPointerException("sourceElement must not be null");
        }
        for (SourceElement child : sourceElement.getChildren()) {
            if (!name.equals(child.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFollowing(SourceElement sourceElement) {
        return !SourcePath.getFollowing(sourceElement, null).isEmpty();
    }

    public static boolean hasPreceding(SourceElement sourceElement) {
        return !SourcePath.getPreceding(sourceElement, sourceElement.getName()).isEmpty();
    }

    public static boolean hasFollowingSibling(SourceElement sourceElement) {
        return !SourcePath.getFollowing(sourceElement, sourceElement.getName()).isEmpty();
    }

    public static boolean hasPrecedingSibling(SourceElement sourceElement) {
        return !SourcePath.getPreceding(sourceElement, sourceElement.getName()).isEmpty();
    }

    public static List<SourceElement> getPreceding(SourceElement sourceElement, String name) {
        if (sourceElement == null) {
            throw new NullPointerException("sourceElement must not be null");
        }
        ArrayList<SourceElement> result = new ArrayList<SourceElement>();
        ListIterator<SourceElement> sameLevelIt = SourcePath.getSiblingIteratorPositionedOnSelf(sourceElement, sourceElement.getParent());
        if (sameLevelIt == null) {
            return result;
        }
        boolean first = true;
        while (sameLevelIt.hasPrevious()) {
            SourceElement sameLevelElement = sameLevelIt.previous();
            if (first) {
                first = false;
                continue;
            }
            if (name != null && !name.equals(sameLevelElement.getName())) continue;
            result.add(sameLevelElement);
        }
        return result;
    }

    public static List<SourceElement> getFollowing(SourceElement sourceElement, String name) {
        if (sourceElement == null) {
            throw new NullPointerException("sourceElement must not be null");
        }
        ArrayList<SourceElement> result = new ArrayList<SourceElement>();
        ListIterator<SourceElement> sameLevelIt = SourcePath.getSiblingIteratorPositionedOnSelf(sourceElement, sourceElement.getParent());
        if (sameLevelIt == null) {
            return result;
        }
        while (sameLevelIt.hasNext()) {
            SourceElement sameLevelElement = sameLevelIt.next();
            if (name != null && !name.equals(sameLevelElement.getName())) continue;
            result.add(sameLevelElement);
        }
        return result;
    }

    protected static ListIterator<SourceElement> getSiblingIteratorPositionedOnSelf(SourceElement sourceElement, SourceElement parent) {
        if (parent == null) {
            return null;
        }
        ListIterator<SourceElement> sameLevelIt = parent.getChildren().listIterator();
        boolean found = false;
        while (sameLevelIt.hasNext()) {
            SourceElement sameLevelElement = sameLevelIt.next();
            if (sameLevelElement != sourceElement) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Inconsistent source tree: Source element " + sourceElement.getName() + " not found in the list of the children of its parent");
        }
        return sameLevelIt;
    }

    public static Iterator<SourcePathPointer> iteratePointer(Object root, String pathToBase, Object base, String path) {
        JXPathContext context;
        if (base == null) {
            throw new NullPointerException("base must not be null");
        }
        if (path == null) {
            path = THIS_TOKEN;
        }
        if (root != null) {
            JXPathContext rootContext = JXPathContext.newContext((Object)root);
            if (root instanceof SourceElement && pathToBase.startsWith(PATH_LEVEL_SEPARATOR)) {
                int slashIndex = pathToBase.indexOf(47, 1);
                pathToBase = slashIndex != -1 ? pathToBase.substring(slashIndex + 1) : PATH_LEVEL_SEPARATOR;
            }
            try {
                context = rootContext.getRelativeContext(rootContext.getPointer(pathToBase));
            }
            catch (JXPathException e) {
                throw new IllegalArgumentException("The pathToBase " + pathToBase + " is not found in root " + String.valueOf(root), e);
            }
            context.setFunctions((Functions)new FunctionLibrary());
            Object pathValue = context.getValue(THIS_TOKEN);
            if (pathValue != base) {
                throw new IllegalArgumentException("The pathToBase " + pathToBase + " does not evaluate to base " + String.valueOf(base) + " from root " + String.valueOf(root));
            }
            if (THIS_TOKEN.equals(path)) {
                return new SourcePathPointerIterator(JXPathContext.newContext((Object)root).iteratePointers(pathToBase));
            }
        } else {
            context = JXPathContext.newContext((Object)base);
        }
        context.setLenient(true);
        Iterator jxpathPointerIterator = context.iteratePointers(path);
        return new SourcePathPointerIterator(jxpathPointerIterator);
    }

    public static List<SourceElement> getElements(SourceElement sourceElement, String path) {
        if (sourceElement == null) {
            throw new NullPointerException("sourceElement must not be null");
        }
        if (path.equals(THIS_TOKEN)) {
            ArrayList<SourceElement> result = new ArrayList<SourceElement>(1);
            result.add(sourceElement);
            return result;
        }
        StringTokenizer selectionPathTokenizer = new StringTokenizer(path, PATH_LEVEL_SEPARATOR);
        ArrayList<SourceElement> currentSelection = new ArrayList<SourceElement>();
        currentSelection.add(sourceElement);
        while (selectionPathTokenizer.hasMoreTokens()) {
            String childName = selectionPathTokenizer.nextToken();
            ArrayList<SourceElement> nextSelection = new ArrayList<SourceElement>();
            for (SourceElement currentElement : currentSelection) {
                if (childName.equals(PARENT_TOKEN)) {
                    SourceElement parent = currentElement.getParent();
                    if (parent != null && !nextSelection.contains(parent)) {
                        nextSelection.add(parent);
                    }
                } else if (ANY_ELEMENT_TOKEN.equals(childName)) {
                    for (SourceElement child : currentElement.getChildren()) {
                        nextSelection.add(child);
                    }
                }
                for (SourceElement child : currentElement.getChildren(childName)) {
                    nextSelection.add(child);
                }
            }
            currentSelection = nextSelection;
        }
        return currentSelection;
    }

    public static List<SourceElement> getElementsFromRoot(SourceElement rootElement, String path) {
        String firstElementName;
        int firstSeparatorPos;
        if (rootElement == null) {
            throw new NullPointerException("rootElement must not be null");
        }
        if (path == null || "".equals(path.trim()) || PATH_LEVEL_SEPARATOR.equals(path.trim())) {
            ArrayList<SourceElement> result = new ArrayList<SourceElement>(1);
            result.add(rootElement);
            return result;
        }
        if ((path = path.trim()).startsWith(PATH_LEVEL_SEPARATOR)) {
            path = path.substring(1);
        }
        if ((firstSeparatorPos = path.indexOf(PATH_LEVEL_SEPARATOR)) == -1) {
            firstElementName = path;
            path = THIS_TOKEN;
        } else {
            firstElementName = path.substring(0, firstSeparatorPos);
            path = path.substring(firstSeparatorPos + 1);
        }
        if (!ANY_ELEMENT_TOKEN.equals(firstElementName) && !rootElement.getName().equals(firstElementName)) {
            return new ArrayList<SourceElement>();
        }
        return SourcePath.getElements(rootElement, path);
    }

    public static Object getObject(SourceElement root, String pathToBase, SourceElement sourceElement, String path, boolean acceptEmpty) throws GeneratorException {
        Iterator<SourcePathPointer> sourceElementIt = SourcePath.iteratePointer(root, pathToBase, sourceElement, path);
        if (!sourceElementIt.hasNext()) {
            if (acceptEmpty) {
                return null;
            }
            throw new GeneratorException("Source element path " + path + " selects no element on source element " + sourceElement.getName());
        }
        SourcePathPointer sourcePathPointer = sourceElementIt.next();
        if (sourceElementIt.hasNext()) {
            throw new GeneratorException("Source element path " + path + " selects more than a single element on source element " + sourceElement.getName());
        }
        return sourcePathPointer.getValue();
    }

    public static SourceElement getElement(SourceElement sourceElement, String path, boolean acceptEmpty) throws GeneratorException {
        List<SourceElement> sourceElements = SourcePath.getElements(sourceElement, path);
        if (sourceElements.isEmpty()) {
            if (acceptEmpty) {
                return null;
            }
            throw new GeneratorException("Source element path " + path + " selects no element on source element " + sourceElement.getName());
        }
        if (sourceElements.size() > 1) {
            throw new GeneratorException("Source element path " + path + " selects more than a single element on source element " + sourceElement.getName());
        }
        return sourceElements.get(0);
    }

    public static String getPathAsString(SourceElement sourceElement) throws GeneratorException {
        StringBuilder result = new StringBuilder();
        SourcePath.getParentPath(sourceElement, new HashSet<SourceElement>(), result);
        result.append(sourceElement.getName());
        return result.toString();
    }

    private static void getParentPath(SourceElement toProcess, Set<SourceElement> alreadyProcessed, StringBuilder result) throws GeneratorException {
        SourceElement parent = toProcess.getParent();
        if (alreadyProcessed.contains(parent)) {
            throw new GeneratorException("getParentPath(): invoked on a closed loop");
        }
        if (parent == null) {
            return;
        }
        result.insert(0, parent.getName() + PATH_LEVEL_SEPARATOR);
        alreadyProcessed.add(parent);
        SourcePath.getParentPath(parent, alreadyProcessed, result);
    }

    static {
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new SourceElementNodePointerFactory());
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new ModelNodeFactory());
    }

    private static final class SourcePathPointerIterator
    implements Iterator<SourcePathPointer> {
        private final Iterator<?> jxpathPointerIterator;

        public SourcePathPointerIterator(Iterator<?> jxpathPointerIterator) {
            if (jxpathPointerIterator == null) {
                throw new NullPointerException("jxpathPointerIterator must not be null");
            }
            this.jxpathPointerIterator = jxpathPointerIterator;
        }

        @Override
        public boolean hasNext() {
            return this.jxpathPointerIterator.hasNext();
        }

        @Override
        public SourcePathPointer next() {
            Pointer pointer = (Pointer)this.jxpathPointerIterator.next();
            return new SourcePathPointer(pointer.getNode(), pointer.asPath());
        }

        @Override
        public void remove() {
            this.jxpathPointerIterator.remove();
        }
    }
}

