/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.audit;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.deltaspike.data.impl.audit.PrePersistAuditListener;
import org.apache.deltaspike.data.impl.audit.PreUpdateAuditListener;
import org.apache.deltaspike.data.impl.property.Property;
import org.apache.deltaspike.data.impl.property.query.AnnotatedPropertyCriteria;
import org.apache.deltaspike.data.impl.property.query.PropertyQueries;
import org.apache.deltaspike.data.impl.property.query.PropertyQuery;

abstract class AuditProvider
implements PrePersistAuditListener,
PreUpdateAuditListener {
    protected static final Logger log = Logger.getLogger(AuditProvider.class.getName());

    AuditProvider() {
    }

    String propertyName(Object entity, Property<Object> property) {
        return entity.getClass().getSimpleName() + "." + property.getName();
    }

    List<Property<Object>> getProperties(Object entity, Class<? extends Annotation> createdAnnotation, Class<? extends Annotation> modifiedAnnotation, boolean create) {
        LinkedList<Property<Object>> properties = new LinkedList<Property<Object>>();
        PropertyQuery query = PropertyQueries.createQuery(entity.getClass()).addCriteria(new AnnotatedPropertyCriteria(modifiedAnnotation));
        properties.addAll(query.getWritableResultList());
        if (create) {
            query = PropertyQueries.createQuery(entity.getClass()).addCriteria(new AnnotatedPropertyCriteria(createdAnnotation));
            properties.addAll(query.getWritableResultList());
        }
        return properties;
    }
}

