/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.io.Externalizable;
import org.apache.directory.api.util.SequencedHashMap;

public final class SynchronizedLRUMap
extends SequencedHashMap
implements Externalizable {
    private static final long serialVersionUID = 2197433140769957051L;
    private int maximumSize = 0;
    protected static final int DEFAULT_MAX_SIZE = 100;

    public SynchronizedLRUMap() {
        this(100);
    }

    public SynchronizedLRUMap(int maxSize) {
        super(maxSize);
        this.maximumSize = maxSize;
    }

    @Override
    public synchronized Object get(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        Object value = this.remove(key);
        super.put(key, value);
        return value;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (this.maximumSize <= this.size() && !this.containsKey(key)) {
            this.removeLRU();
        }
        return super.put(key, value);
    }

    private void removeLRU() {
        Object key = this.getFirstKey();
        super.get(key);
        this.remove(key);
    }

    public synchronized int getMaximumSize() {
        return this.maximumSize;
    }

    public synchronized void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
        while (this.size() > maximumSize) {
            this.removeLRU();
        }
    }
}

