/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.factory;

import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.factory.Messagefactory;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public final class BindRequestFactory
implements Messagefactory {
    public static final BindRequestFactory INSTANCE = new BindRequestFactory();

    private BindRequestFactory() {
    }

    @Override
    public void encodeReverse(LdapApiService codec, Asn1Buffer buffer, Message message) {
        int start = buffer.getPos();
        BindRequest bindMessage = (BindRequest)message;
        if (bindMessage.isSimple()) {
            BerValue.encodeOctetString((Asn1Buffer)buffer, (byte)-128, (byte[])bindMessage.getCredentials());
        } else {
            if (!Strings.isEmpty((byte[])bindMessage.getCredentials())) {
                BerValue.encodeOctetString((Asn1Buffer)buffer, (byte[])bindMessage.getCredentials());
            }
            BerValue.encodeOctetString((Asn1Buffer)buffer, (String)bindMessage.getSaslMechanism());
            BerValue.encodeSequence((Asn1Buffer)buffer, (byte)-93, (int)start);
        }
        Dn dn = bindMessage.getDn();
        if (!Dn.isNullOrEmpty((Dn)dn)) {
            BerValue.encodeOctetString((Asn1Buffer)buffer, (String)dn.getName());
        } else {
            BerValue.encodeOctetString((Asn1Buffer)buffer, (String)bindMessage.getName());
        }
        BerValue.encodeInteger((Asn1Buffer)buffer, (int)3);
        BerValue.encodeSequence((Asn1Buffer)buffer, (byte)96, (int)start);
    }
}

