/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.internal.cli.CommandManager;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.springframework.shell.converters.ArrayConverter;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.SimpleParser;
import org.springframework.shell.event.ParseResult;

public class GfshParser
extends SimpleParser {
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String OPTION_VALUE_SPECIFIER = "=";
    public static final String OPTION_SEPARATOR = " ";
    public static final String SHORT_OPTION_SPECIFIER = "-";
    public static final String LONG_OPTION_SPECIFIER = "--";
    public static final String COMMAND_DELIMITER = ";";
    public static final String CONTINUATION_CHARACTER = "\\";
    private static final char ASCII_UNIT_SEPARATOR = '\u001f';
    public static final String J_ARGUMENT_DELIMITER = "\u001f";
    public static final String J_OPTION_CONTEXT = "splittingRegex=\u001f";
    private final CommandManager commandManager;

    public GfshParser(CommandManager commandManager) {
        this.commandManager = commandManager;
        for (CommandMarker commandMarker : commandManager.getCommandMarkers()) {
            this.add(commandMarker);
        }
        for (Converter converter : commandManager.getConverters()) {
            if (converter.getClass().isAssignableFrom(ArrayConverter.class)) {
                ArrayConverter arrayConverter = (ArrayConverter)converter;
                arrayConverter.setConverters(new HashSet(commandManager.getConverters()));
            }
            this.add(converter);
        }
    }

    static String convertToSimpleParserInput(String userInput) {
        List<String> inputTokens = GfshParser.splitUserInput(userInput);
        return GfshParser.getSimpleParserInputFromTokens(inputTokens);
    }

    private static List<String> splitWithWhiteSpace(String input) {
        ArrayList<String> tokensList = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        char insideQuoteOf = '\u0000';
        for (char c : input.toCharArray()) {
            if (Character.isWhitespace(c)) {
                if (insideQuoteOf != '\u0000') {
                    token.append(c);
                    continue;
                }
                if (token.length() > 0) {
                    tokensList.add(token.toString());
                }
                token = new StringBuilder();
                continue;
            }
            token.append(c);
            if (c != '\'' && c != '\"') continue;
            if (insideQuoteOf == '\u0000') {
                insideQuoteOf = c;
                continue;
            }
            if (insideQuoteOf != c) continue;
            insideQuoteOf = '\u0000';
        }
        if (token.length() > 0) {
            tokensList.add(token.toString());
        }
        return tokensList;
    }

    static List<String> splitUserInput(String userInput) {
        List<String> splitWithWhiteSpaces = GfshParser.splitWithWhiteSpace(userInput);
        ArrayList<String> furtherSplitWithEquals = new ArrayList<String>();
        for (String token : splitWithWhiteSpaces) {
            if (token.startsWith("'") || token.startsWith("\"") || token.startsWith("-D")) {
                furtherSplitWithEquals.add(token);
                continue;
            }
            int indexOfFirstEqual = token.indexOf(61);
            if (indexOfFirstEqual < 0) {
                furtherSplitWithEquals.add(token);
                continue;
            }
            String left = token.substring(0, indexOfFirstEqual);
            String right = token.substring(indexOfFirstEqual + 1);
            if (left.length() > 0) {
                furtherSplitWithEquals.add(left);
            }
            if (right.length() <= 0) continue;
            furtherSplitWithEquals.add(right);
        }
        return furtherSplitWithEquals;
    }

    static String getSimpleParserInputFromTokens(List<String> tokens) {
        ArrayList<String> inputTokens = new ArrayList<String>();
        int firstJIndex = -1;
        ArrayList<String> jArguments = new ArrayList<String>();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if ("--J".equals(token)) {
                if (firstJIndex < 1) {
                    firstJIndex = i;
                }
                if (++i >= tokens.size()) continue;
                String jArg = tokens.get(i);
                if (jArg.charAt(0) == '\"' || jArg.charAt(0) == '\'') {
                    jArg = jArg.substring(1, jArg.length() - 1);
                }
                if (jArg.length() <= 0) continue;
                jArguments.add(jArg);
                continue;
            }
            inputTokens.add(token);
        }
        StringBuilder rawInput = new StringBuilder();
        for (int i = 0; i <= inputTokens.size(); ++i) {
            if (i == firstJIndex) {
                rawInput.append("--J ");
                if (jArguments.size() > 0) {
                    rawInput.append("\"").append(StringUtils.join(jArguments, (String)J_ARGUMENT_DELIMITER)).append("\" ");
                }
            }
            if (i >= inputTokens.size()) continue;
            rawInput.append((String)inputTokens.get(i)).append(OPTION_SEPARATOR);
        }
        return rawInput.toString().trim();
    }

    @Override
    public GfshParseResult parse(String userInput) {
        String rawInput = GfshParser.convertToSimpleParserInput(userInput);
        ParseResult result = super.parse(rawInput = rawInput.replace(CONTINUATION_CHARACTER, "\\\\"));
        if (result == null) {
            String missingHelp = this.commandManager.getHelper().getMiniHelp(userInput);
            if (missingHelp != null) {
                System.out.println(missingHelp);
            }
            return null;
        }
        return new GfshParseResult(result.getMethod(), result.getInstance(), result.getArguments(), userInput);
    }

    @Override
    public int completeAdvanced(String userInput, int cursor, List<Completion> candidates) {
        int candidateBeginAt;
        List<String> inputTokens = GfshParser.splitUserInput(userInput);
        boolean inputIsBeforeOption = true;
        for (String token : inputTokens) {
            if (!token.startsWith(LONG_OPTION_SPECIFIER)) continue;
            inputIsBeforeOption = false;
            break;
        }
        if (inputIsBeforeOption) {
            int curs = this.completeSpecial(candidates, userInput, inputTokens, "help", "geode.converter.help:disable-string-converter");
            if (curs > 0) {
                return curs;
            }
            curs = this.completeSpecial(candidates, userInput, inputTokens, "hint", "geode.converter.hint:disable-string-converter");
            if (curs > 0) {
                return curs;
            }
            List<Completion> potentials = this.getCandidates(userInput);
            if (potentials.size() == 1 && potentials.get(0).getValue().equals(userInput)) {
                potentials = this.getCandidates(userInput.trim() + OPTION_SEPARATOR);
            }
            if (potentials.size() > 0) {
                candidates.addAll(potentials);
                return 0;
            }
        }
        String buffer = GfshParser.getSimpleParserInputFromTokens(inputTokens);
        String lastToken = inputTokens.get(inputTokens.size() - 1);
        boolean lastTokenIsOption = lastToken.startsWith(LONG_OPTION_SPECIFIER);
        List<Completion> potentials = this.getCandidates(buffer);
        if (potentials.size() == 0 || userInput.endsWith(OPTION_SEPARATOR)) {
            candidateBeginAt = buffer.length();
            if (lastTokenIsOption) {
                potentials = this.getCandidates(buffer + OPTION_SEPARATOR);
                lastTokenIsOption = false;
            } else {
                potentials = this.getCandidates(buffer + " --");
                lastTokenIsOption = true;
            }
        } else {
            candidateBeginAt = lastTokenIsOption ? buffer.length() - lastToken.length() : buffer.length() - lastToken.length() - 1;
        }
        if (lastTokenIsOption) {
            potentials.replaceAll(completion -> new Completion(completion.getValue().substring(candidateBeginAt)));
        } else if (!userInput.endsWith(OPTION_VALUE_SPECIFIER)) {
            potentials.replaceAll(completion -> new Completion(OPTION_VALUE_SPECIFIER + completion.getValue()));
        }
        candidates.addAll(potentials);
        cursor = candidateBeginAt + (userInput.trim().length() - buffer.length());
        return cursor;
    }

    private Converter<?> converterFor(String converterHint) {
        for (Converter<String> converter : this.getConverters()) {
            if (!converter.supports(String.class, converterHint)) continue;
            return converter;
        }
        return null;
    }

    private int completeSpecial(List<Completion> candidates, String userInput, List<String> inputTokens, String cmd, String converterHint) {
        if (inputTokens.get(0).equals(cmd)) {
            String prefix = userInput.equals(cmd) ? OPTION_SEPARATOR : "";
            String existing = String.join((CharSequence)OPTION_SEPARATOR, inputTokens.subList(1, inputTokens.size())).toLowerCase();
            ArrayList<Completion> all = new ArrayList<Completion>();
            Converter<?> converter = this.converterFor(converterHint);
            if (converter != null) {
                converter.getAllPossibleValues(all, null, null, null, null);
                candidates.addAll(all.stream().filter(c -> c.getValue().toLowerCase().startsWith(existing)).map(c -> new Completion(prefix + c.getValue())).collect(Collectors.toList()));
                return Math.min(userInput.length(), cmd.length() + 1);
            }
        }
        return 0;
    }

    private List<Completion> getCandidates(String buffer) {
        ArrayList<Completion> candidates = new ArrayList<Completion>();
        super.completeAdvanced(buffer, buffer.length(), candidates);
        candidates.replaceAll(completion -> new Completion(completion.getValue().trim()));
        return candidates;
    }
}

