/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class ResultsSet
extends HashSet
implements SelectResults,
DataSerializableFixedID {
    private static final long serialVersionUID = -5423281031630216824L;
    private ObjectType elementType;

    public ResultsSet() {
    }

    ResultsSet(Collection c) {
        super(c);
    }

    public ResultsSet(SelectResults sr) {
        super(sr);
        this.setElementType(sr.getCollectionType().getElementType());
    }

    public ResultsSet(ObjectType elementType) {
        this.setElementType(elementType);
    }

    ResultsSet(ObjectType elementType, int initialCapacity) {
        super(initialCapacity);
        this.setElementType(elementType);
    }

    ResultsSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    ResultsSet(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (elementType instanceof StructType) {
            throw new IllegalArgumentException("This collection does not support struct elements");
        }
        this.elementType = elementType;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResultsSet)) {
            return false;
        }
        if (!this.elementType.equals(((ResultsSet)other).elementType)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.elementType.hashCode();
    }

    public List asList() {
        return new ArrayList(this);
    }

    public Set asSet() {
        return this;
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(Set.class, this.elementType);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public int occurrences(Object element) {
        return this.contains(element) ? 1 : 0;
    }

    public int getDSFID() {
        return 28;
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ObjectTypeImpl clt = new ObjectTypeImpl();
        InternalDataSerializer.invokeFromData(clt, in);
        this.setElementType(clt);
        for (int k = size; k > 0; --k) {
            this.add(context.getDeserializer().readObject(in));
        }
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeInt(this.size());
        ObjectTypeImpl ctImpl = (ObjectTypeImpl)this.getCollectionType().getElementType();
        Assert.assertTrue(ctImpl != null, "ctImpl can not be null");
        InternalDataSerializer.invokeToData(ctImpl, out);
        for (Object o : this) {
            context.getSerializer().writeObject(o, out);
        }
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

