/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;

public class ObjIdConcurrentMap<V>
implements Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment<V>[] segments;

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    Segment<V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public ObjIdConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
    }

    public ObjIdConcurrentMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public ObjIdConcurrentMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public ObjIdConcurrentMap() {
        this(16, 0.75f, 16);
    }

    public boolean isEmpty() {
        int i;
        Segment<V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    public int size() {
        Segment<V>[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            sum = 0L;
            for (Segment<V> value : segments) {
                value.lock();
            }
            for (Segment<V> vSegment : segments) {
                sum += (long)vSegment.count;
            }
            for (Segment<V> segment : segments) {
                segment.unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public V get(int key) {
        int hash = ObjIdConcurrentMap.hash(key);
        return this.segmentFor(hash).get(key, hash);
    }

    public boolean containsKey(int key) {
        int hash = ObjIdConcurrentMap.hash(key);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Segment<V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int mcsum = 0;
            for (int i = 0; i < segments.length; ++i) {
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                if (!segments[i].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i = 0; i < segments.length; ++i) {
                    if (mc[i] == segments[i].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (Segment<V> vSegment : segments) {
            vSegment.lock();
        }
        boolean found = false;
        try {
            for (Segment<V> segment : segments) {
                if (!segment.containsValue(value)) continue;
                found = true;
                break;
            }
        }
        finally {
            for (Segment<V> segment : segments) {
                segment.unlock();
            }
        }
        return found;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public V put(int key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ObjIdConcurrentMap.hash(key);
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    public V putIfAbsent(int key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ObjIdConcurrentMap.hash(key);
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    public V remove(int key) {
        int hash = ObjIdConcurrentMap.hash(key);
        return this.segmentFor(hash).remove(key, hash, null);
    }

    public boolean remove(int key, Object value) {
        int hash = ObjIdConcurrentMap.hash(key);
        if (value == null) {
            return false;
        }
        return this.segmentFor(hash).remove(key, hash, value) != null;
    }

    public boolean replace(int key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = ObjIdConcurrentMap.hash(key);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    public V replace(int key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ObjIdConcurrentMap.hash(key);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    public void clear() {
        for (Segment<V> segment : this.segments) {
            segment.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (Segment<V> seg : this.segments) {
            seg.lock();
            try {
                HashEntry<V>[] tab;
                HashEntry<V>[] hashEntryArray = tab = seg.table;
                int n = hashEntryArray.length;
                for (int i = 0; i < n; ++i) {
                    HashEntry vHashEntry;
                    HashEntry e = vHashEntry = hashEntryArray[i];
                    while (e != null) {
                        s.writeObject(e.key);
                        s.writeObject(e.value);
                        e = e.next;
                    }
                }
            }
            finally {
                seg.unlock();
            }
        }
        s.writeObject(null);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        for (Segment<V> segment : this.segments) {
            segment.setTable(new HashEntry[1]);
        }
        while (true) {
            int key = s.readInt();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    static class Segment<V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry<V>[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(HashEntry.newArray(initialCapacity));
        }

        static <K, V> Segment<V>[] newArray(int i) {
            return new Segment[i];
        }

        void setTable(HashEntry<V>[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        HashEntry<V> getFirst(int hash) {
            HashEntry<V>[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        V readValueUnderLock(HashEntry<V> e) {
            this.lock();
            try {
                Object v = e.value;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(int key, int hash) {
            if (this.count != 0) {
                HashEntry<V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key == e.key) {
                        Object v = e.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = e.next;
                }
            }
            return null;
        }

        boolean containsKey(int key, int hash) {
            if (this.count != 0) {
                HashEntry<V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key == e.key) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return false;
        }

        boolean containsValue(Object value) {
            if (this.count != 0) {
                HashEntry<V>[] tab = this.table;
                int len = tab.length;
                HashEntry<V>[] hashEntryArray = tab;
                int n = hashEntryArray.length;
                for (int i = 0; i < n; ++i) {
                    HashEntry<V> vHashEntry;
                    HashEntry<V> e = vHashEntry = hashEntryArray[i];
                    while (e != null) {
                        Object v = e.value;
                        if (v == null) {
                            v = this.readValueUnderLock(e);
                        }
                        if (value.equals(v)) {
                            return true;
                        }
                        e = e.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(int key, int hash, V oldValue, V newValue) {
            this.lock();
            try {
                HashEntry<V> e = this.getFirst(hash);
                while (e != null && (e.hash != hash || key != e.key)) {
                    e = e.next;
                }
                boolean replaced = false;
                if (e != null && oldValue.equals(e.value)) {
                    replaced = true;
                    e.value = newValue;
                }
                boolean bl = replaced;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(int key, int hash, V newValue) {
            this.lock();
            try {
                HashEntry<V> e = this.getFirst(hash);
                while (e != null && (e.hash != hash || key != e.key)) {
                    e = e.next;
                }
                V oldValue = null;
                if (e != null) {
                    oldValue = e.value;
                    e.value = newValue;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(int key, int hash, V value, boolean onlyIfAbsent) {
            this.lock();
            try {
                V oldValue;
                HashEntry<V> first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashEntry<V>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<V> e = first = tab[index];
                while (e != null && (e.hash != hash || key != e.key)) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = e.value;
                    if (!onlyIfAbsent) {
                        e.value = value;
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = new HashEntry<V>(key, hash, first, value);
                    this.count = c;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            HashEntry<V>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry<V>[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (HashEntry<V> e : oldTable) {
                int k;
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry<V> lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry<V> p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = new HashEntry(p.key, p.hash, n, p.value);
                    p = p.next;
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(int key, int hash, Object value) {
            this.lock();
            try {
                HashEntry<V> first;
                int c = this.count - 1;
                HashEntry<V>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<V> e = first = tab[index];
                while (e != null && (e.hash != hash || key != e.key)) {
                    e = e.next;
                }
                V oldValue = null;
                if (e != null) {
                    Object v = e.value;
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        HashEntry newFirst = e.next;
                        HashEntry<V> p = first;
                        while (p != e) {
                            newFirst = new HashEntry(p.key, p.hash, newFirst, p.value);
                            p = p.next;
                        }
                        tab[index] = newFirst;
                        this.count = c;
                    }
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<V>[] tab = this.table;
                    for (int i = 0; i < tab.length; ++i) {
                        tab[i] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static class HashEntry<V> {
        final int key;
        final int hash;
        volatile V value;
        final HashEntry<V> next;

        HashEntry(int key, int hash, HashEntry<V> next, V value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }

        static <V> HashEntry<V>[] newArray(int i) {
            return new HashEntry[i];
        }
    }
}

