/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.RegionStatus;

public class PartitionedRegionStatus
extends RegionStatus {
    private static final long serialVersionUID = -6755318987122602065L;
    protected int numberOfLocalEntries;

    public PartitionedRegionStatus(PartitionedRegion region) {
        this.initialize(region);
    }

    @Override
    public long getHeapSize() {
        return this.heapSize;
    }

    private void setHeapSize(long heapSize) {
        this.heapSize = heapSize;
    }

    private void initialize(PartitionedRegion region) {
        this.setNumberOfEntries(region.size());
        PartitionedRegionDataStore ds = region.getDataStore();
        long heapSize = 0L;
        if (ds != null) {
            heapSize = ds.currentAllocatedMemory();
        }
        this.setHeapSize(heapSize);
    }

    @Override
    public String toString() {
        return "PartitionedRegionStatus[numberOfEntries=" + this.numberOfEntries + "; numberOfLocalEntries=" + this.numberOfLocalEntries + "; heapSize=" + this.heapSize + "]";
    }
}

