/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.RegisterDataSerializersOp;
import org.apache.geode.cache.client.internal.RegisterInstantiatorsOp;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PoolManagerImpl {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static PoolManagerImpl impl = new PoolManagerImpl(true);
    private volatile Map<String, Pool> pools = Collections.emptyMap();
    private volatile Optional<Iterator<Pool>> itrForEmergencyClose = Optional.empty();
    private final Object poolLock = new Object();
    private final boolean normalManager;

    public static PoolManagerImpl getPMI() {
        PoolManagerImpl result = CacheCreation.getCurrentPoolManager();
        if (result == null) {
            result = impl;
        }
        return result;
    }

    @VisibleForTesting
    public static void setImpl(PoolManagerImpl poolManager) {
        impl = poolManager;
    }

    public PoolManagerImpl(boolean addListener) {
        this.normalManager = addListener;
    }

    public boolean isNormal() {
        return this.normalManager;
    }

    public PoolFactory createFactory() {
        return new PoolFactoryImpl(this);
    }

    public Pool find(String name) {
        return this.pools.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean keepAlive) {
        boolean foundClientPool = false;
        Object object = this.poolLock;
        synchronized (object) {
            for (Map.Entry<String, Pool> entry : this.pools.entrySet()) {
                Pool pool = entry.getValue();
                if (!(pool instanceof PoolImpl)) continue;
                ((PoolImpl)pool).basicDestroy(keepAlive);
                foundClientPool = true;
            }
            this.pools = Collections.emptyMap();
            this.itrForEmergencyClose = Optional.empty();
            if (foundClientPool) {
                ServerConnection.emptyCommBufferPool();
            }
        }
    }

    public Map<String, Pool> getMap() {
        return new HashMap<String, Pool>(this.pools);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Pool pool) {
        Object object = this.poolLock;
        synchronized (object) {
            HashMap<String, Pool> copy = new HashMap<String, Pool>(this.pools);
            String name = pool.getName();
            Pool old = copy.put(name, pool);
            if (old != null) {
                throw new IllegalStateException(String.format("A pool named %s already exists", name));
            }
            this.pools = Collections.unmodifiableMap(copy);
            this.itrForEmergencyClose = Optional.of(copy.values().iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(Pool pool) {
        int attachCount = 0;
        if (pool instanceof PoolImpl) {
            attachCount = ((PoolImpl)pool).getAttachCount();
        }
        if (attachCount > 0) {
            throw new IllegalStateException(String.format("Pool could not be destroyed because it is still in use by %s regions", attachCount));
        }
        Object object = this.poolLock;
        synchronized (object) {
            HashMap<String, Pool> copy = new HashMap<String, Pool>(this.pools);
            String name = pool.getName();
            Object rmPool = copy.remove(name);
            if (rmPool == null || rmPool != pool) {
                return false;
            }
            this.pools = Collections.unmodifiableMap(copy);
            this.itrForEmergencyClose = Optional.of(copy.values().iterator());
            return true;
        }
    }

    public String toString() {
        return super.toString() + "-" + (this.normalManager ? "normal" : "xml");
    }

    public static void readyForEvents(InternalDistributedSystem system, boolean xmlPoolsOnly) {
        boolean foundDurablePool = false;
        Map<String, Pool> pools = PoolManager.getAll();
        for (Pool pool : pools.values()) {
            PoolImpl p;
            if (!(pool instanceof PoolImpl) || !(p = (PoolImpl)pool).isDurableClient()) continue;
            foundDurablePool = true;
            if (xmlPoolsOnly) continue;
            p.readyForEvents(system);
        }
        if (pools.size() > 0 && !foundDurablePool) {
            throw new IllegalStateException("Only durable clients should call readyForEvents()");
        }
    }

    public static void allPoolsRegisterInstantiator(Instantiator instantiator) {
        Instantiator[] instantiators = new Instantiator[]{instantiator};
        for (Pool pool : PoolManager.getAll().values()) {
            try {
                EventID eventId = InternalInstantiator.generateEventId();
                if (eventId == null) continue;
                RegisterInstantiatorsOp.execute((ExecutablePool)((Object)pool), instantiators, eventId);
            }
            catch (RuntimeException e) {
                logger.warn("Error registering instantiator on pool:", (Throwable)e);
            }
        }
    }

    public static void allPoolsRegisterInstantiator(InternalInstantiator.InstantiatorAttributesHolder holder) {
        Object[] holders = new InternalInstantiator.InstantiatorAttributesHolder[]{holder};
        for (Pool pool : PoolManager.getAll().values()) {
            try {
                EventID eventId = InternalInstantiator.generateEventId();
                if (eventId == null) continue;
                RegisterInstantiatorsOp.execute((ExecutablePool)((Object)pool), holders, eventId);
            }
            catch (RuntimeException e) {
                logger.warn("Error registering instantiator on pool:", (Throwable)e);
            }
        }
    }

    public static void allPoolsRegisterDataSerializers(DataSerializer dataSerializer) {
        DataSerializer[] dataSerializers = new DataSerializer[]{dataSerializer};
        for (Pool pool : PoolManager.getAll().values()) {
            try {
                EventID eventId = (EventID)dataSerializer.getEventId();
                if (eventId == null) {
                    eventId = InternalDataSerializer.generateEventId();
                }
                if (eventId == null || pool.getMultiuserAuthentication()) continue;
                RegisterDataSerializersOp.execute((ExecutablePool)((Object)pool), dataSerializers, eventId);
            }
            catch (RuntimeException e) {
                logger.warn("Error registering instantiator on pool:", (Throwable)e);
            }
        }
    }

    public static void allPoolsRegisterDataSerializers(InternalDataSerializer.SerializerAttributesHolder holder) {
        InternalDataSerializer.SerializerAttributesHolder[] holders = new InternalDataSerializer.SerializerAttributesHolder[]{holder};
        for (Pool pool : PoolManager.getAll().values()) {
            try {
                EventID eventId = holder.getEventId();
                if (eventId == null) {
                    eventId = InternalDataSerializer.generateEventId();
                }
                if (eventId == null || pool.getMultiuserAuthentication()) continue;
                RegisterDataSerializersOp.execute((ExecutablePool)((Object)pool), holders, eventId);
            }
            catch (RuntimeException e) {
                logger.warn("Error registering instantiator on pool:", (Throwable)e);
            }
        }
    }

    public static void emergencyClose() {
        PoolManagerImpl.impl.itrForEmergencyClose.ifPresent(poolIterator -> {
            while (poolIterator.hasNext()) {
                Pool pool = (Pool)poolIterator.next();
                if (!(pool instanceof PoolImpl)) continue;
                ((PoolImpl)pool).emergencyClose();
            }
        });
    }

    public Pool find(Region<?, ?> region) {
        return this.find(region.getAttributes().getPoolName());
    }
}

