/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.RegionMembershipListener;
import org.apache.geode.distributed.DistributedMember;

class WrappedRegionMembershipListener
implements RegionMembershipListener {
    private final RegionMembershipListener wrappedListener;
    private final Object initLock = new Object();
    private boolean initialized;

    public WrappedRegionMembershipListener(RegionMembershipListener listener) {
        this.wrappedListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = this.initLock;
        synchronized (object) {
            return this.initialized;
        }
    }

    public RegionMembershipListener getWrappedListener() {
        return this.wrappedListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRemoteRegionCrash(RegionEvent event) {
        Object object = this.initLock;
        synchronized (object) {
            if (this.initialized) {
                this.wrappedListener.afterRemoteRegionCrash(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRemoteRegionCreate(RegionEvent event) {
        Object object = this.initLock;
        synchronized (object) {
            if (this.initialized) {
                this.wrappedListener.afterRemoteRegionCreate(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRemoteRegionDeparture(RegionEvent event) {
        Object object = this.initLock;
        synchronized (object) {
            if (this.initialized) {
                this.wrappedListener.afterRemoteRegionDeparture(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialMembers(Region region, DistributedMember[] initialMembers) {
        Object object = this.initLock;
        synchronized (object) {
            if (!this.initialized) {
                this.wrappedListener.initialMembers(region, initialMembers);
                this.initialized = true;
            }
        }
    }

    @Override
    public void afterCreate(EntryEvent event) {
        this.wrappedListener.afterCreate(event);
    }

    @Override
    public void afterDestroy(EntryEvent event) {
        this.wrappedListener.afterDestroy(event);
    }

    @Override
    public void afterInvalidate(EntryEvent event) {
        this.wrappedListener.afterInvalidate(event);
    }

    @Override
    public void afterRegionClear(RegionEvent event) {
        this.wrappedListener.afterRegionClear(event);
    }

    @Override
    public void afterRegionCreate(RegionEvent event) {
        this.wrappedListener.afterRegionCreate(event);
    }

    @Override
    public void afterRegionDestroy(RegionEvent event) {
        this.wrappedListener.afterRegionDestroy(event);
    }

    @Override
    public void afterRegionInvalidate(RegionEvent event) {
        this.wrappedListener.afterRegionInvalidate(event);
    }

    @Override
    public void afterRegionLive(RegionEvent event) {
        this.wrappedListener.afterRegionLive(event);
    }

    @Override
    public void afterUpdate(EntryEvent event) {
        this.wrappedListener.afterUpdate(event);
    }

    @Override
    public void close() {
        this.wrappedListener.close();
    }

    public boolean equals(Object obj) {
        return this.wrappedListener.equals(obj);
    }

    public int hashCode() {
        return this.wrappedListener.hashCode();
    }

    public String toString() {
        return this.wrappedListener.toString();
    }
}

