/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.util.Set;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.backup.BackupStep;
import org.apache.geode.internal.cache.backup.FlushToDiskFactory;

class FlushToDiskStep
extends BackupStep {
    private final InternalDistributedMember member;
    private final InternalCache cache;
    private final Set<InternalDistributedMember> recipients;
    private final FlushToDiskFactory flushToDiskFactory;

    FlushToDiskStep(DistributionManager dm, InternalDistributedMember member, InternalCache cache, Set<InternalDistributedMember> recipients, FlushToDiskFactory flushToDiskFactory) {
        super(dm);
        this.flushToDiskFactory = flushToDiskFactory;
        this.member = member;
        this.recipients = recipients;
        this.cache = cache;
    }

    @Override
    ReplyProcessor21 createReplyProcessor() {
        return this.flushToDiskFactory.createReplyProcessor(this.getDistributionManager(), this.recipients);
    }

    @Override
    DistributionMessage createDistributionMessage(ReplyProcessor21 replyProcessor) {
        return this.flushToDiskFactory.createRequest(this.member, this.recipients, replyProcessor.getProcessorId());
    }

    @Override
    void processLocally() {
        this.flushToDiskFactory.createFlushToDisk(this.cache).run();
    }
}

