/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketPersistenceAdvisor;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.PRHARedundancyProvider;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.ProxyBucketRegion;
import org.apache.geode.internal.cache.partitioned.RecoveryRunnable;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentStateListener;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.process.StartupStatus;
import org.apache.geode.internal.util.TransformUtils;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PersistentBucketRecoverer
extends RecoveryRunnable
implements PersistentStateListener {
    private static final Logger logger = LogService.getLogger();
    private volatile boolean membershipChanged = true;
    private static final int SLEEP_PERIOD = 15000;
    private final CountDownLatch allBucketsRecoveredFromDisk;
    private final List<RegionStatus> regions;
    private final StartupStatus startupStatus;

    public PersistentBucketRecoverer(PRHARedundancyProvider prhaRedundancyProvider, int proxyBuckets) {
        this(prhaRedundancyProvider, proxyBuckets, new StartupStatus());
    }

    private PersistentBucketRecoverer(PRHARedundancyProvider prhaRedundancyProvider, int proxyBuckets, StartupStatus startupStatus) {
        super(prhaRedundancyProvider);
        this.startupStatus = startupStatus;
        PartitionedRegion baseRegion = ColocationHelper.getLeaderRegion(this.redundancyProvider.getPartitionedRegion());
        List<PartitionedRegion> colocatedRegions = this.getColocatedChildRegions(baseRegion);
        ArrayList<RegionStatus> allRegions = new ArrayList<RegionStatus>(colocatedRegions.size() + 1);
        if (baseRegion.getDataPolicy().withPersistence()) {
            allRegions.add(new RegionStatus(baseRegion));
        }
        for (PartitionedRegion region : colocatedRegions) {
            if (!region.getDataPolicy().withPersistence()) continue;
            allRegions.add(new RegionStatus(region));
        }
        this.regions = allRegions;
        this.allBucketsRecoveredFromDisk = new CountDownLatch(proxyBuckets);
        this.membershipChanged = true;
        this.addListeners();
    }

    List<PartitionedRegion> getColocatedChildRegions(PartitionedRegion baseRegion) {
        return ColocationHelper.getColocatedChildRegions(baseRegion);
    }

    public void startLoggingThread() {
        LoggingThread loggingThread = new LoggingThread("PersistentBucketRecoverer for region " + this.redundancyProvider.getPartitionedRegion().getName(), false, (Runnable)this);
        loggingThread.start();
    }

    @Override
    public void memberOnline(InternalDistributedMember member, PersistentMemberID persistentID) {
        this.membershipChanged = true;
    }

    @Override
    public void memberOffline(InternalDistributedMember member, PersistentMemberID persistentID) {
        this.membershipChanged = true;
    }

    @Override
    public void memberRemoved(PersistentMemberID persistentID, boolean revoked) {
        this.membershipChanged = true;
    }

    private void addListeners() {
        for (RegionStatus region : this.regions) {
            region.addListeners();
        }
    }

    private void removeListeners() {
        for (RegionStatus region : this.regions) {
            region.removeListeners();
        }
    }

    List<RegionStatus> getRegions() {
        return this.regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run2() {
        try {
            boolean warningLogged = false;
            while (this.getLatchCount() > 0L) {
                int sleepMillis = 15000;
                if (!warningLogged) {
                    sleepMillis = 7500;
                }
                if (this.regions.isEmpty()) {
                    break;
                }
                Thread.sleep(sleepMillis);
                if (!this.membershipChanged) continue;
                this.membershipChanged = false;
                Iterator<RegionStatus> itr = this.regions.iterator();
                while (itr.hasNext()) {
                    RegionStatus region = itr.next();
                    try {
                        region.logWaitingForMembers();
                    }
                    catch (RegionDestroyedException e) {
                        itr.remove();
                    }
                }
                warningLogged = true;
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (!this.regions.isEmpty()) {
                this.removeListeners();
                for (RegionStatus region : this.regions) {
                    if (region.loggedDoneMessage) continue;
                    region.logDoneMessage();
                }
                this.regions.clear();
            }
        }
    }

    public void await(long timeout, TimeUnit unit) {
        boolean interrupted = false;
        while (true) {
            try {
                boolean done;
                do {
                    this.redundancyProvider.getPartitionedRegion().getCancelCriterion().checkCancelInProgress(null);
                } while (!(done = this.allBucketsRecoveredFromDisk.await(timeout, unit)));
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void await() {
        boolean interrupted = false;
        while (true) {
            try {
                this.getAllBucketsRecoveredFromDiskLatch().await();
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void countDown() {
        this.allBucketsRecoveredFromDisk.countDown();
    }

    public void countDown(int size) {
        while (size > 0) {
            this.allBucketsRecoveredFromDisk.countDown();
            --size;
        }
    }

    public boolean hasRecoveryCompleted() {
        return this.getLatchCount() <= 0L;
    }

    long getLatchCount() {
        return this.allBucketsRecoveredFromDisk.getCount();
    }

    CountDownLatch getAllBucketsRecoveredFromDiskLatch() {
        return this.allBucketsRecoveredFromDisk;
    }

    private class RegionStatus {
        private final PersistentMemberID thisMember;
        private final String region;
        private final ProxyBucketRegion[] bucketRegions;
        private volatile boolean loggedDoneMessage = true;

        public RegionStatus(PartitionedRegion region) {
            this.thisMember = this.createPersistentMemberID(region);
            this.region = region.getFullPath();
            this.bucketRegions = region.getRegionAdvisor().getProxyBucketArray();
        }

        public void removeListeners() {
            for (ProxyBucketRegion proxyBucket : this.bucketRegions) {
                proxyBucket.getPersistenceAdvisor().removeListener(PersistentBucketRecoverer.this);
            }
        }

        public void addListeners() {
            for (ProxyBucketRegion proxyBucket : this.bucketRegions) {
                proxyBucket.getPersistenceAdvisor().addListener(PersistentBucketRecoverer.this);
            }
        }

        private PersistentMemberID createPersistentMemberID(PartitionedRegion region) {
            DiskStoreImpl diskStore = null;
            if (region.getAttributes().getDataPolicy().withPersistence()) {
                diskStore = region.getDiskStore();
            } else if (ColocationHelper.getLeaderRegion(region).getAttributes().getDataPolicy().withPersistence()) {
                diskStore = ColocationHelper.getLeaderRegion(region).getDiskStore();
            }
            if (null != diskStore) {
                return diskStore.generatePersistentID();
            }
            String name = "No name for this member";
            String diskDir = System.getProperty("user.dir");
            InetAddress localHost = null;
            try {
                localHost = LocalHostUtil.getLocalHost();
            }
            catch (UnknownHostException e) {
                logger.error("Could not determine my own host", (Throwable)e);
            }
            return new PersistentMemberID(null, localHost, diskDir, name, PersistentBucketRecoverer.this.redundancyProvider.getPartitionedRegion().getCache().cacheTimeMillis(), 0);
        }

        private Map<PersistentMemberID, Set<Integer>> getMembersToWaitFor(boolean offlineOnly) throws RegionDestroyedException {
            HashMap<PersistentMemberID, Set<Integer>> waitingForMembers = new HashMap<PersistentMemberID, Set<Integer>>();
            boolean allBucketsClosed = true;
            for (ProxyBucketRegion proxyBucket : this.bucketRegions) {
                Integer bucketId = proxyBucket.getBucketId();
                BucketPersistenceAdvisor persistenceAdvisor = proxyBucket.getPersistenceAdvisor();
                if (persistenceAdvisor.isClosed()) continue;
                allBucketsClosed = false;
                Set<PersistentMemberID> missingMembers = offlineOnly ? persistenceAdvisor.getMissingMembers() : persistenceAdvisor.getAllMembersToWaitFor();
                if (missingMembers == null) continue;
                for (PersistentMemberID missingMember : missingMembers) {
                    TreeSet<Integer> buckets = (TreeSet<Integer>)waitingForMembers.get(missingMember);
                    if (buckets == null) {
                        buckets = new TreeSet<Integer>();
                        waitingForMembers.put(missingMember, buckets);
                    }
                    buckets.add(bucketId);
                }
            }
            if (allBucketsClosed) {
                throw new RegionDestroyedException("The Region has been closed or destroyed", this.region);
            }
            return waitingForMembers;
        }

        private void logDoneMessage() {
            this.loggedDoneMessage = true;
            PersistentBucketRecoverer.this.startupStatus.startup(String.format("Region %s has successfully completed waiting for other members to recover the latest data. My persistent member information:%s", this.region, TransformUtils.persistentMemberIdToLogEntryTransformer.transform(this.thisMember)), new Object[0]);
        }

        private void logWaitingForMembers() throws RegionDestroyedException {
            boolean thereAreBucketsToBeRecovered;
            Map<PersistentMemberID, Set<Integer>> offlineMembers = this.getMembersToWaitFor(true);
            Map<PersistentMemberID, Set<Integer>> allMembersToWaitFor = this.getMembersToWaitFor(false);
            boolean bl = thereAreBucketsToBeRecovered = PersistentBucketRecoverer.this.getLatchCount() > 0L;
            if (thereAreBucketsToBeRecovered && !offlineMembers.isEmpty()) {
                HashSet membersToWaitForLogEntries = new HashSet();
                TransformUtils.transform(offlineMembers.entrySet(), membersToWaitForLogEntries, TransformUtils.persistentMemberEntryToLogEntryTransformer);
                Set<Integer> missingBuckets = this.getAllWaitingBuckets(offlineMembers);
                PersistentBucketRecoverer.this.startupStatus.startup(String.format("Region %s (and any colocated sub-regions) has potentially stale data.  Buckets %s are waiting for another offline member to recover the latest data. My persistent id is:%sOffline members with potentially new data:%sUse the gfsh show missing-disk-stores command to see all disk stores that are being waited on by other members.", this.region, missingBuckets, TransformUtils.persistentMemberIdToLogEntryTransformer.transform(this.thisMember), membersToWaitForLogEntries), new Object[0]);
                this.loggedDoneMessage = false;
            } else if (thereAreBucketsToBeRecovered && !allMembersToWaitFor.isEmpty()) {
                HashSet membersToWaitForLogEntries = new HashSet();
                Set<Integer> missingBuckets = this.getAllWaitingBuckets(allMembersToWaitFor);
                TransformUtils.transform(allMembersToWaitFor.entrySet(), membersToWaitForLogEntries, TransformUtils.persistentMemberEntryToLogEntryTransformer);
                PersistentBucketRecoverer.this.startupStatus.startup(String.format("Region %s (and any colocated sub-regions) has potentially stale data.  Buckets %s are waiting for another online member to recover the latest data. My persistent id is:%sOnline members with potentially new data:%sUse the gfsh show missing-disk-stores command to see all disk stores that are being waited on by other members.", this.region, missingBuckets, TransformUtils.persistentMemberIdToLogEntryTransformer.transform(this.thisMember), membersToWaitForLogEntries), new Object[0]);
                this.loggedDoneMessage = false;
            } else if (!this.loggedDoneMessage) {
                this.logDoneMessage();
            }
        }

        private Set<Integer> getAllWaitingBuckets(Map<PersistentMemberID, Set<Integer>> offlineMembers) {
            TreeSet<Integer> allWaitingBuckets = new TreeSet<Integer>();
            for (Set<Integer> missingPerMember : offlineMembers.values()) {
                allWaitingBuckets.addAll(missingPerMember);
            }
            return allWaitingBuckets;
        }
    }
}

