/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.GemFireSecurityException;
import org.jetbrains.annotations.NotNull;

public class RemoveUserAuth
extends BaseCommand {
    @Immutable
    private static final RemoveUserAuth singleton = new RemoveUserAuth();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, ClassNotFoundException, InterruptedException {
        boolean isSecureMode = clientMessage.isSecureMode();
        if (!isSecureMode) {
            return;
        }
        try {
            serverConnection.setAsTrue(2);
            Part keepalivePart = clientMessage.getPart(0);
            byte[] keepaliveByte = keepalivePart.getSerializedForm();
            boolean keepalive = keepaliveByte != null && keepaliveByte[0] != 0;
            serverConnection.getSecurityLogWriter().fine("remove user auth keep alive " + keepalive);
            serverConnection.removeUserAuth(clientMessage, keepalive);
            this.writeReply(clientMessage, serverConnection);
        }
        catch (GemFireSecurityException gfse) {
            if (serverConnection.getSecurityLogWriter().warningEnabled()) {
                serverConnection.getSecurityLogWriter().warning(String.format("%s", serverConnection.getName() + ": Security exception: " + gfse.getMessage()));
            }
            RemoveUserAuth.writeException(clientMessage, gfse, false, serverConnection);
        }
        catch (Exception ex) {
            if (serverConnection.getLogWriter().warningEnabled()) {
                serverConnection.getLogWriter().warning(String.format("An exception was thrown for client [%s]. %s", serverConnection.getProxyID(), ""), (Throwable)ex);
            }
            RemoveUserAuth.writeException(clientMessage, ex, false, serverConnection);
        }
        finally {
            serverConnection.setAsTrue(1);
        }
    }
}

