/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class AbortableTaskService {
    private final Executor exec;
    private final Queue<AbortingRunnable> tasks;

    public AbortableTaskService(Executor exec) {
        this.exec = exec;
        this.tasks = new ConcurrentLinkedQueue<AbortingRunnable>();
    }

    public void execute(AbortableTask task) {
        AbortingRunnable ar = new AbortingRunnable(task);
        this.tasks.add(ar);
        try {
            this.exec.execute(ar);
        }
        catch (RejectedExecutionException e) {
            this.tasks.remove(ar);
            throw e;
        }
    }

    public void abortAll() {
        for (AbortingRunnable ar : this.tasks) {
            ar.abort();
        }
    }

    public void waitForCompletion() {
        boolean interrupted = false;
        for (AbortingRunnable ar : this.tasks) {
            try {
                ar.waitForCompletion();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted() {
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            AbortingRunnable ar;
            AbortingRunnable abortingRunnable = ar = (AbortingRunnable)iterator.next();
            synchronized (abortingRunnable) {
                if (!ar.done) {
                    return false;
                }
            }
        }
        return true;
    }

    private class AbortingRunnable
    implements Runnable {
        private final AbortableTask task;
        private final AtomicBoolean aborted;
        private final AtomicBoolean hasStarted;
        private boolean done;

        public AbortingRunnable(AbortableTask task) {
            this.task = task;
            this.aborted = new AtomicBoolean(false);
            this.hasStarted = new AtomicBoolean(false);
            this.done = false;
        }

        private synchronized void waitForCompletion() throws InterruptedException {
            while (!this.done) {
                this.wait();
            }
        }

        private synchronized void signalDone() {
            this.done = true;
            this.notifyAll();
        }

        private void abort() {
            this.aborted.set(true);
            if (this.hasStarted.compareAndSet(false, true)) {
                try {
                    this.task.abortBeforeRun();
                }
                finally {
                    AbortableTaskService.this.tasks.remove(this);
                    this.signalDone();
                }
            }
        }

        @Override
        public void run() {
            if (this.hasStarted.compareAndSet(false, true)) {
                try {
                    this.task.runOrAbort(this.aborted);
                }
                finally {
                    AbortableTaskService.this.tasks.remove(this);
                    this.signalDone();
                }
            }
        }
    }

    public static interface AbortableTask {
        public void runOrAbort(AtomicBoolean var1);

        public void abortBeforeRun();
    }
}

