/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.datastructure;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.reuse.ReuseBag;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageHandler;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public abstract class DataStructure {
    public static Random rnd;
    private final String name;
    private final PageLockListener lockLsnr;
    protected final int grpId;
    protected final String grpName;
    protected final PageMemory pageMem;
    @Nullable
    protected ReuseList reuseList;
    protected final byte defaultPageFlag;
    protected final int partId;

    public DataStructure(String name, int grpId, @Nullable String grpName, int partId, PageMemory pageMem, PageLockListener lockLsnr, byte defaultPageFlag) {
        assert (!StringUtils.nullOrEmpty((String)name));
        assert (pageMem != null);
        assert (partId >= 0 && partId <= 65500) : partId;
        this.name = name;
        this.grpId = grpId;
        this.grpName = grpName;
        this.partId = partId;
        this.pageMem = pageMem;
        this.lockLsnr = lockLsnr;
        this.defaultPageFlag = defaultPageFlag;
    }

    public final String name() {
        return this.name;
    }

    public final int groupId() {
        return this.grpId;
    }

    public static int randomInt(int max) {
        Random rnd0 = rnd != null ? rnd : ThreadLocalRandom.current();
        return rnd0.nextInt(max);
    }

    protected final long allocatePage(@Nullable ReuseBag bag) throws IgniteInternalCheckedException {
        return this.allocatePage(bag, true);
    }

    protected final long allocatePage(@Nullable ReuseBag bag, boolean useRecycled) throws IgniteInternalCheckedException {
        long pageId = 0L;
        if (useRecycled && this.reuseList != null) {
            long l = pageId = bag != null ? bag.pollFreePage() : 0L;
            if (pageId == 0L) {
                pageId = this.reuseList.takeRecycledPage();
            }
            if (pageId != 0L) {
                pageId = this.reuseList.initRecycledPage(pageId, this.defaultPageFlag, null);
            }
        }
        if (pageId == 0L) {
            pageId = this.allocatePageNoReuse();
        }
        assert (pageId != 0L);
        assert (PageIdUtils.partitionId(pageId) >= 0 && PageIdUtils.partitionId(pageId) <= 65500) : PageIdUtils.toDetailString(pageId);
        assert (PageIdUtils.flag(pageId) != 1 || PageIdUtils.itemId(pageId) == 0) : PageIdUtils.toDetailString(pageId);
        return pageId;
    }

    protected long allocatePageNoReuse() throws IgniteInternalCheckedException {
        return this.pageMem.allocatePage(this.grpId, this.partId, this.defaultPageFlag);
    }

    protected final long acquirePage(long pageId, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        assert (PageIdUtils.partitionId(pageId) >= 0 && PageIdUtils.partitionId(pageId) <= 65500) : PageIdUtils.toDetailString(pageId);
        return this.pageMem.acquirePage(this.grpId, pageId, statHolder);
    }

    protected final void releasePage(long pageId, long page) {
        this.pageMem.releasePage(this.grpId, pageId, page);
    }

    protected final long tryWriteLock(long pageId, long page) {
        return PageHandler.writeLock(this.pageMem, this.grpId, pageId, page, this.lockLsnr, true);
    }

    protected final long writeLock(long pageId, long page) {
        return PageHandler.writeLock(this.pageMem, this.grpId, pageId, page, this.lockLsnr, false);
    }

    protected final long readLock(long pageId, long page) {
        return PageHandler.readLock(this.pageMem, this.grpId, pageId, page, this.lockLsnr);
    }

    protected final void readUnlock(long pageId, long page, long pageAddr) {
        PageHandler.readUnlock(this.pageMem, this.grpId, pageId, page, pageAddr, this.lockLsnr);
    }

    protected final void writeUnlock(long pageId, long page, long pageAddr, boolean dirty) {
        PageHandler.writeUnlock(this.pageMem, this.grpId, pageId, page, pageAddr, this.lockLsnr, dirty);
    }

    protected final <R> R write(long pageId, PageHandler<?, R> h, int intArg, R lockFailed, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        return PageHandler.writePage(this.pageMem, this.grpId, pageId, this.lockLsnr, h, null, null, intArg, lockFailed, statHolder);
    }

    protected final <X, R> R write(long pageId, PageHandler<X, R> h, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        return PageHandler.writePage(this.pageMem, this.grpId, pageId, this.lockLsnr, h, null, arg, intArg, lockFailed, statHolder);
    }

    protected final <X, R> R write(long pageId, long page, PageHandler<X, R> h, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        return PageHandler.writePage(this.pageMem, this.grpId, pageId, page, this.lockLsnr, h, null, arg, intArg, lockFailed, statHolder);
    }

    protected final <X, R> R write(long pageId, PageHandler<X, R> h, PageIo init, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        return PageHandler.writePage(this.pageMem, this.grpId, pageId, this.lockLsnr, h, init, arg, intArg, lockFailed, statHolder);
    }

    protected final <X, R> R read(long pageId, PageHandler<X, R> h, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        return PageHandler.readPage(this.pageMem, this.grpId, pageId, this.lockLsnr, h, arg, intArg, lockFailed, statHolder);
    }

    protected final <X, R> R read(long pageId, long page, PageHandler<X, R> h, X arg, int intArg, R lockFailed, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        return PageHandler.readPage(this.pageMem, this.grpId, pageId, page, this.lockLsnr, h, arg, intArg, lockFailed, statHolder);
    }

    protected final void init(long pageId, PageIo init) throws IgniteInternalCheckedException {
        PageHandler.initPage(this.pageMem, this.grpId, pageId, init, this.lockLsnr, IoStatisticsHolderNoOp.INSTANCE);
    }

    protected final long recyclePage(long pageId, long pageAddr) {
        int rotatedIdPart;
        long recycled = 0L;
        if (PageIdUtils.flag(pageId) == 1 && (rotatedIdPart = PageIo.getRotatedIdPart(pageAddr)) != 0) {
            recycled = PageIdUtils.link(pageId, rotatedIdPart);
            PageIo.setRotatedIdPart(pageAddr, 0);
        }
        if (recycled == 0L) {
            recycled = PageIdUtils.rotatePageId(pageId);
        }
        assert (PageIdUtils.itemId(recycled) > 0 && PageIdUtils.itemId(recycled) <= 254) : IgniteUtils.hexLong((long)recycled);
        PageIo.setPageId(pageAddr, recycled);
        return recycled;
    }

    protected int pageSize() {
        return this.pageMem.realPageSize(this.grpId);
    }

    public void close() {
        this.lockLsnr.close();
    }
}

