/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.fileio.FileIo;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.persistence.FastCrc;
import org.apache.ignite.internal.pagememory.persistence.IgniteInternalDataIntegrityViolationException;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteSystemProperties;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFilePageStoreIo
implements Closeable {
    protected final FileIoFactory ioFactory;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final boolean skipCrc = IgniteSystemProperties.getBoolean((String)"IGNITE_PDS_SKIP_CRC");
    private volatile Path filePath;
    @Nullable
    private volatile FileIo fileIo;
    private volatile boolean initialized;
    @Nullable
    private Boolean fileExists;

    AbstractFilePageStoreIo(FileIoFactory ioFactory, Path filePath) {
        this.ioFactory = ioFactory;
        this.filePath = filePath;
    }

    public abstract int pageSize();

    public abstract int headerSize();

    public abstract ByteBuffer headerBuffer();

    public abstract void checkHeader(FileIo var1) throws IOException;

    public abstract long pageOffset(long var1);

    public void stop(boolean clean) throws IgniteInternalCheckedException {
        try {
            this.stop0(clean);
        }
        catch (IOException e) {
            throw new IgniteInternalCheckedException("Failed to stop serving file [file=" + this.filePath + ", delete=" + clean + "]", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.stop0(false);
    }

    protected void read(long pageId, long pageOff, ByteBuffer pageBuf, boolean keepCrc) throws IgniteInternalCheckedException {
        this.read0(pageId, pageOff, pageBuf, !this.skipCrc, keepCrc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long pageId, ByteBuffer pageBuf, boolean calculateCrc) throws IgniteInternalCheckedException {
        this.ensure();
        boolean interrupted = false;
        while (true) {
            FileIo fileIo = this.fileIo;
            try {
                this.readWriteLock.readLock().lock();
                try {
                    assert (pageBuf.position() == 0) : pageBuf.position();
                    assert (pageBuf.order() == ByteOrder.nativeOrder()) : "Page buffer order " + pageBuf.order() + " should be same with " + ByteOrder.nativeOrder();
                    assert (PageIo.getType(pageBuf) != 0) : "Invalid state. Type is 0! pageId = " + IgniteUtils.hexLong((long)pageId);
                    assert (PageIo.getVersion(pageBuf) != 0) : "Invalid state. Version is 0! pageId = " + IgniteUtils.hexLong((long)pageId);
                    if (calculateCrc && !this.skipCrc) {
                        assert (PageIo.getCrc(pageBuf) == 0) : IgniteUtils.hexLong((long)pageId);
                        PageIo.setCrc(pageBuf, AbstractFilePageStoreIo.calcCrc32(pageBuf, this.pageSize()));
                    }
                    assert (this.skipCrc || PageIo.getCrc(pageBuf) != 0 || AbstractFilePageStoreIo.calcCrc32(pageBuf, this.pageSize()) == 0) : "CRC hasn't been calculated, crc=0";
                    assert (pageBuf.position() == 0) : pageBuf.position();
                    long pageOff = this.pageOffset(pageId);
                    fileIo.writeFully(pageBuf, pageOff);
                    PageIo.setCrc(pageBuf, 0);
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                finally {
                    this.readWriteLock.readLock().unlock();
                }
            }
            catch (IOException e) {
                block19: {
                    if (e instanceof ClosedChannelException) {
                        try {
                            if (e instanceof ClosedByInterruptException) {
                                interrupted = true;
                                Thread.interrupted();
                            }
                            this.reinit(fileIo);
                            pageBuf.position(0);
                            PageIo.setCrc(pageBuf, 0);
                        }
                        catch (IOException e0) {
                            e0.addSuppressed(e);
                            e = e0;
                            break block19;
                        }
                        continue;
                    }
                }
                throw new IgniteInternalCheckedException("Failed to write page [filePath=" + this.filePath + ", pageId=" + pageId + "]", (Throwable)e);
            }
            break;
        }
    }

    public void sync() throws IgniteInternalCheckedException {
        this.ensure();
        this.readWriteLock.readLock().lock();
        try {
            FileIo fileIo = this.fileIo;
            if (fileIo != null) {
                fileIo.force();
            }
        }
        catch (IOException e) {
            throw new IgniteInternalCheckedException("Failed to fsync file [filePath=" + this.filePath + "]", (Throwable)e);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public boolean exists() {
        this.readWriteLock.readLock().lock();
        try {
            if (this.fileExists == null) {
                this.fileExists = Files.exists(this.filePath, new LinkOption[0]) && this.filePath.toFile().length() >= (long)this.headerSize();
            }
            boolean bl = this.fileExists;
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensure() throws IgniteInternalCheckedException {
        block19: {
            if (!this.initialized) {
                this.readWriteLock.writeLock().lock();
                try {
                    if (this.initialized) break block19;
                    FileIo fileIo = null;
                    IgniteInternalCheckedException err = null;
                    try {
                        boolean interrupted = false;
                        while (true) {
                            try {
                                this.fileIo = fileIo = this.ioFactory.create(this.filePath, new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE});
                                this.fileExists = true;
                                if (fileIo.size() < (long)this.headerSize()) {
                                    fileIo.writeFully(this.headerBuffer().rewind(), 0L);
                                } else {
                                    this.checkHeader(fileIo);
                                }
                                if (!interrupted) break;
                                Thread.currentThread().interrupt();
                            }
                            catch (ClosedByInterruptException e) {
                                interrupted = true;
                                Thread.interrupted();
                                continue;
                            }
                            break;
                        }
                        this.initialized = true;
                    }
                    catch (IOException e) {
                        err = new IgniteInternalCheckedException("Failed to initialize partition file: " + this.filePath, (Throwable)e);
                        throw err;
                    }
                    finally {
                        if (err != null && fileIo != null) {
                            try {
                                fileIo.close();
                            }
                            catch (IOException e) {
                                err.addSuppressed((Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    this.readWriteLock.writeLock().unlock();
                }
            }
        }
    }

    public long size() throws IgniteInternalCheckedException {
        this.readWriteLock.readLock().lock();
        try {
            FileIo io = this.fileIo;
            long l = io == null ? 0L : io.size();
            return l;
        }
        catch (IOException e) {
            throw new IgniteInternalCheckedException((Throwable)e);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private void stop0(boolean clean) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            if (!this.initialized) {
                if (this.fileIo != null) {
                    this.fileIo.close();
                }
                if (clean && this.exists()) {
                    Files.delete(this.filePath);
                }
                return;
            }
            this.fileIo.force();
            this.fileIo.close();
            this.fileIo = null;
            if (clean) {
                Files.delete(this.filePath);
                this.fileExists = false;
            }
        }
        finally {
            this.initialized = false;
            this.readWriteLock.writeLock().unlock();
        }
    }

    private static int calcCrc32(ByteBuffer pageBuf, int pageSize) {
        try {
            pageBuf.position(0);
            int n = FastCrc.calcCrc(pageBuf, pageSize);
            return n;
        }
        finally {
            pageBuf.position(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit(FileIo fileIo) throws IOException {
        if (fileIo != this.fileIo) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        try {
            if (fileIo != this.fileIo) {
                return;
            }
            try {
                boolean interrupted = false;
                while (true) {
                    try {
                        fileIo = null;
                        fileIo = this.ioFactory.create(this.filePath, new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE});
                        this.fileExists = true;
                        this.checkHeader(fileIo);
                        this.fileIo = fileIo;
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    catch (ClosedByInterruptException e) {
                        interrupted = true;
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                try {
                    if (fileIo != null) {
                        fileIo.close();
                    }
                }
                catch (IOException e0) {
                    e.addSuppressed(e0);
                }
                throw e;
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void read0(long pageId, long pageOff, ByteBuffer pageBuf, boolean checkCrc, boolean keepCrc) throws IgniteInternalCheckedException {
        assert (pageOff >= (long)this.headerSize()) : "pageOff=" + pageOff + ", headerSize=" + this.headerSize();
        this.ensure();
        try {
            int curCrc32;
            assert (pageBuf.capacity() == this.pageSize()) : pageBuf.capacity();
            assert (pageBuf.remaining() == this.pageSize()) : pageBuf.remaining();
            assert (pageBuf.position() == 0) : pageBuf.position();
            assert (pageBuf.order() == ByteOrder.nativeOrder()) : pageBuf.order();
            int n = this.readWithFailover(pageBuf, pageOff);
            if (n < 0) {
                pageBuf.put(new byte[pageBuf.remaining()]);
                return;
            }
            int savedCrc32 = PageIo.getCrc(pageBuf);
            PageIo.setCrc(pageBuf, 0);
            pageBuf.position(0);
            if (checkCrc && (savedCrc32 ^ (curCrc32 = FastCrc.calcCrc(pageBuf, this.pageSize()))) != 0) {
                throw new IgniteInternalDataIntegrityViolationException("Failed to read page (CRC validation failed) [id=" + IgniteUtils.hexLong((long)pageId) + ", off=" + pageOff + ", filePath=" + this.filePath + ", fileSize=" + this.fileIo.size() + ", savedCrc=" + IgniteUtils.hexInt((int)savedCrc32) + ", curCrc=" + IgniteUtils.hexInt((int)curCrc32) + ", page=" + IgniteUtils.toHexString((ByteBuffer)pageBuf) + "]");
            }
            assert (PageIo.getCrc(pageBuf) == 0);
            if (keepCrc) {
                PageIo.setCrc(pageBuf, savedCrc32);
            }
        }
        catch (IOException e) {
            throw new IgniteInternalCheckedException("Failed to read page [file=" + this.filePath + ", pageId=" + pageId + "]", (Throwable)e);
        }
    }

    private int readWithFailover(ByteBuffer destBuf, long position) throws IOException {
        boolean interrupted = false;
        int bufPos = destBuf.position();
        while (true) {
            FileIo fileIo;
            if ((fileIo = this.fileIo) == null) {
                throw new IOException("FileIo has stopped");
            }
            try {
                assert (destBuf.remaining() > 0);
                int bytesRead = fileIo.readFully(destBuf, position);
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return bytesRead;
            }
            catch (ClosedChannelException e) {
                destBuf.position(bufPos);
                if (e instanceof ClosedByInterruptException) {
                    interrupted = true;
                    Thread.interrupted();
                }
                this.reinit(fileIo);
                continue;
            }
            break;
        }
    }

    public Path filePath() {
        return this.filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFilePath(Path newFilePath) throws IOException {
        this.initialized = false;
        this.readWriteLock.writeLock().lock();
        try {
            Path filePath = this.filePath;
            if (!filePath.equals(newFilePath)) {
                FileIo fileIo = this.fileIo;
                assert (fileIo != null) : "Tried to rename right after creation: " + filePath;
                fileIo.force();
                fileIo.close();
                IgniteUtils.atomicMoveFile((Path)filePath, (Path)newFilePath, null);
                this.filePath = newFilePath;
                if (fileIo != null) {
                    this.reinit(fileIo);
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

