/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server.raft;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.ignite.internal.metastorage.common.ConditionType;
import org.apache.ignite.internal.metastorage.common.MetaStorageException;
import org.apache.ignite.internal.metastorage.common.StatementInfo;
import org.apache.ignite.internal.metastorage.common.StatementResultInfo;
import org.apache.ignite.internal.metastorage.common.UpdateInfo;
import org.apache.ignite.internal.metastorage.common.command.CompoundConditionInfo;
import org.apache.ignite.internal.metastorage.common.command.CompoundConditionType;
import org.apache.ignite.internal.metastorage.common.command.ConditionInfo;
import org.apache.ignite.internal.metastorage.common.command.GetAllCommand;
import org.apache.ignite.internal.metastorage.common.command.GetAndPutAllCommand;
import org.apache.ignite.internal.metastorage.common.command.GetAndPutCommand;
import org.apache.ignite.internal.metastorage.common.command.GetAndRemoveAllCommand;
import org.apache.ignite.internal.metastorage.common.command.GetAndRemoveCommand;
import org.apache.ignite.internal.metastorage.common.command.GetCommand;
import org.apache.ignite.internal.metastorage.common.command.IfInfo;
import org.apache.ignite.internal.metastorage.common.command.InvokeCommand;
import org.apache.ignite.internal.metastorage.common.command.MultiInvokeCommand;
import org.apache.ignite.internal.metastorage.common.command.MultipleEntryResponse;
import org.apache.ignite.internal.metastorage.common.command.OperationInfo;
import org.apache.ignite.internal.metastorage.common.command.PutAllCommand;
import org.apache.ignite.internal.metastorage.common.command.PutCommand;
import org.apache.ignite.internal.metastorage.common.command.RangeCommand;
import org.apache.ignite.internal.metastorage.common.command.RemoveAllCommand;
import org.apache.ignite.internal.metastorage.common.command.RemoveCommand;
import org.apache.ignite.internal.metastorage.common.command.SimpleConditionInfo;
import org.apache.ignite.internal.metastorage.common.command.SingleEntryResponse;
import org.apache.ignite.internal.metastorage.common.command.WatchExactKeysCommand;
import org.apache.ignite.internal.metastorage.common.command.WatchRangeKeysCommand;
import org.apache.ignite.internal.metastorage.common.command.cursor.CursorCloseCommand;
import org.apache.ignite.internal.metastorage.common.command.cursor.CursorHasNextCommand;
import org.apache.ignite.internal.metastorage.common.command.cursor.CursorNextCommand;
import org.apache.ignite.internal.metastorage.common.command.cursor.CursorsCloseCommand;
import org.apache.ignite.internal.metastorage.server.AndCondition;
import org.apache.ignite.internal.metastorage.server.Condition;
import org.apache.ignite.internal.metastorage.server.Entry;
import org.apache.ignite.internal.metastorage.server.EntryEvent;
import org.apache.ignite.internal.metastorage.server.ExistenceCondition;
import org.apache.ignite.internal.metastorage.server.If;
import org.apache.ignite.internal.metastorage.server.KeyValueStorage;
import org.apache.ignite.internal.metastorage.server.Operation;
import org.apache.ignite.internal.metastorage.server.OrCondition;
import org.apache.ignite.internal.metastorage.server.RevisionCondition;
import org.apache.ignite.internal.metastorage.server.Statement;
import org.apache.ignite.internal.metastorage.server.StatementResult;
import org.apache.ignite.internal.metastorage.server.TombstoneCondition;
import org.apache.ignite.internal.metastorage.server.Update;
import org.apache.ignite.internal.metastorage.server.ValueCondition;
import org.apache.ignite.internal.metastorage.server.WatchEvent;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.raft.client.ReadCommand;
import org.apache.ignite.raft.client.WriteCommand;
import org.apache.ignite.raft.client.service.CommandClosure;
import org.apache.ignite.raft.client.service.RaftGroupListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class MetaStorageListener
implements RaftGroupListener {
    private final KeyValueStorage storage;
    private final Map<IgniteUuid, CursorMeta> cursors;

    public MetaStorageListener(KeyValueStorage storage) {
        this.storage = storage;
        this.cursors = new ConcurrentHashMap<IgniteUuid, CursorMeta>();
    }

    public void onRead(Iterator<CommandClosure<ReadCommand>> iter) {
        while (iter.hasNext()) {
            CommandClosure<ReadCommand> clo = iter.next();
            ReadCommand command = (ReadCommand)clo.command();
            if (command instanceof GetCommand) {
                GetCommand getCmd = (GetCommand)command;
                Entry e = getCmd.revision() != 0L ? this.storage.get(getCmd.key(), getCmd.revision()) : this.storage.get(getCmd.key());
                SingleEntryResponse resp = new SingleEntryResponse(e.key(), e.value(), e.revision(), e.updateCounter());
                clo.result((Serializable)resp);
                continue;
            }
            if (command instanceof GetAllCommand) {
                GetAllCommand getAllCmd = (GetAllCommand)command;
                Collection<Entry> entries = getAllCmd.revision() != 0L ? this.storage.getAll(getAllCmd.keys(), getAllCmd.revision()) : this.storage.getAll(getAllCmd.keys());
                ArrayList<SingleEntryResponse> res = new ArrayList<SingleEntryResponse>(entries.size());
                for (Entry e : entries) {
                    res.add(new SingleEntryResponse(e.key(), e.value(), e.revision(), e.updateCounter()));
                }
                clo.result((Serializable)new MultipleEntryResponse(res));
                continue;
            }
            if (command instanceof CursorHasNextCommand) {
                CursorHasNextCommand cursorHasNextCmd = (CursorHasNextCommand)command;
                CursorMeta cursorDesc = this.cursors.get(cursorHasNextCmd.cursorId());
                clo.result((Serializable)Boolean.valueOf(cursorDesc != null && cursorDesc.cursor().hasNext()));
                continue;
            }
            assert (false) : "Command was not found [cmd=" + command + "]";
        }
    }

    public void onWrite(Iterator<CommandClosure<WriteCommand>> iter) {
        while (iter.hasNext()) {
            WatchRangeKeysCommand watchCmd;
            InvokeCommand cmd;
            CommandClosure<WriteCommand> clo = iter.next();
            WriteCommand command = (WriteCommand)clo.command();
            if (command instanceof PutCommand) {
                PutCommand putCmd = (PutCommand)command;
                this.storage.put(putCmd.key(), putCmd.value());
                clo.result(null);
                continue;
            }
            if (command instanceof GetAndPutCommand) {
                GetAndPutCommand getAndPutCmd = (GetAndPutCommand)command;
                Entry e = this.storage.getAndPut(getAndPutCmd.key(), getAndPutCmd.value());
                clo.result((Serializable)new SingleEntryResponse(e.key(), e.value(), e.revision(), e.updateCounter()));
                continue;
            }
            if (command instanceof PutAllCommand) {
                PutAllCommand putAllCmd = (PutAllCommand)command;
                this.storage.putAll(putAllCmd.keys(), putAllCmd.values());
                clo.result(null);
                continue;
            }
            if (command instanceof GetAndPutAllCommand) {
                GetAndPutAllCommand getAndPutAllCmd = (GetAndPutAllCommand)command;
                Collection<Entry> entries = this.storage.getAndPutAll(getAndPutAllCmd.keys(), getAndPutAllCmd.vals());
                ArrayList<SingleEntryResponse> resp = new ArrayList<SingleEntryResponse>(entries.size());
                for (Entry e : entries) {
                    resp.add(new SingleEntryResponse(e.key(), e.value(), e.revision(), e.updateCounter()));
                }
                clo.result((Serializable)new MultipleEntryResponse(resp));
                continue;
            }
            if (command instanceof RemoveCommand) {
                RemoveCommand rmvCmd = (RemoveCommand)command;
                this.storage.remove(rmvCmd.key());
                clo.result(null);
                continue;
            }
            if (command instanceof GetAndRemoveCommand) {
                GetAndRemoveCommand getAndRmvCmd = (GetAndRemoveCommand)command;
                Entry e = this.storage.getAndRemove(getAndRmvCmd.key());
                clo.result((Serializable)new SingleEntryResponse(e.key(), e.value(), e.revision(), e.updateCounter()));
                continue;
            }
            if (command instanceof RemoveAllCommand) {
                RemoveAllCommand rmvAllCmd = (RemoveAllCommand)command;
                this.storage.removeAll(rmvAllCmd.keys());
                clo.result(null);
                continue;
            }
            if (command instanceof GetAndRemoveAllCommand) {
                GetAndRemoveAllCommand getAndRmvAllCmd = (GetAndRemoveAllCommand)command;
                Collection<Entry> entries = this.storage.getAndRemoveAll(getAndRmvAllCmd.keys());
                ArrayList<SingleEntryResponse> resp = new ArrayList<SingleEntryResponse>(entries.size());
                for (Entry e : entries) {
                    resp.add(new SingleEntryResponse(e.key(), e.value(), e.revision(), e.updateCounter()));
                }
                clo.result((Serializable)new MultipleEntryResponse(resp));
                continue;
            }
            if (command instanceof InvokeCommand) {
                cmd = (InvokeCommand)command;
                boolean res = this.storage.invoke(MetaStorageListener.toCondition(cmd.condition()), MetaStorageListener.toOperations(cmd.success()), MetaStorageListener.toOperations(cmd.failure()));
                clo.result((Serializable)Boolean.valueOf(res));
                continue;
            }
            if (command instanceof MultiInvokeCommand) {
                cmd = (MultiInvokeCommand)command;
                StatementResult res = this.storage.invoke(MetaStorageListener.toIf(cmd.iif()));
                clo.result((Serializable)new StatementResultInfo(res.bytes()));
                continue;
            }
            if (command instanceof RangeCommand) {
                RangeCommand rangeCmd = (RangeCommand)command;
                IgniteUuid cursorId = rangeCmd.getCursorId();
                Cursor<Entry> cursor = rangeCmd.revUpperBound() != -1L ? this.storage.range(rangeCmd.keyFrom(), rangeCmd.keyTo(), rangeCmd.revUpperBound(), rangeCmd.includeTombstones()) : this.storage.range(rangeCmd.keyFrom(), rangeCmd.keyTo(), rangeCmd.includeTombstones());
                this.cursors.put(cursorId, new CursorMeta(cursor, CursorType.RANGE, rangeCmd.requesterNodeId(), rangeCmd.batchSize()));
                clo.result((Serializable)cursorId);
                continue;
            }
            if (command instanceof CursorNextCommand) {
                CursorNextCommand cursorNextCmd = (CursorNextCommand)command;
                CursorMeta cursorDesc = this.cursors.get(cursorNextCmd.cursorId());
                if (cursorDesc == null) {
                    clo.result((Serializable)new NoSuchElementException("Corresponding cursor on the server side is not found."));
                    return;
                }
                try {
                    ArrayList<SingleEntryResponse> resp;
                    if (cursorDesc.type() == CursorType.RANGE) {
                        int batchSize = Objects.requireNonNull(cursorDesc.batchSize());
                        resp = new ArrayList<SingleEntryResponse>(batchSize);
                        for (int i = 0; i < batchSize && cursorDesc.cursor().hasNext(); ++i) {
                            Entry entry = (Entry)cursorDesc.cursor().next();
                            resp.add(new SingleEntryResponse(entry.key(), entry.value(), entry.revision(), entry.updateCounter()));
                        }
                        clo.result((Serializable)new MultipleEntryResponse(resp));
                        continue;
                    }
                    if (cursorDesc.type() != CursorType.WATCH) continue;
                    WatchEvent evt = (WatchEvent)cursorDesc.cursor().next();
                    resp = new ArrayList(evt.entryEvents().size() * 2);
                    for (EntryEvent entryEvent : evt.entryEvents()) {
                        Entry o = entryEvent.oldEntry();
                        Entry n = entryEvent.entry();
                        resp.add(new SingleEntryResponse(o.key(), o.value(), o.revision(), o.updateCounter()));
                        resp.add(new SingleEntryResponse(n.key(), n.value(), n.revision(), n.updateCounter()));
                    }
                    clo.result((Serializable)new MultipleEntryResponse(resp));
                }
                catch (NoSuchElementException e) {
                    clo.result((Serializable)e);
                }
                continue;
            }
            if (command instanceof CursorCloseCommand) {
                CursorCloseCommand cursorCloseCmd = (CursorCloseCommand)command;
                CursorMeta cursorDesc = this.cursors.remove(cursorCloseCmd.cursorId());
                if (cursorDesc == null) {
                    clo.result(null);
                    return;
                }
                try {
                    cursorDesc.cursor().close();
                }
                catch (Exception e) {
                    throw new MetaStorageException(ErrorGroups.MetaStorage.CURSOR_CLOSING_ERR, (Throwable)e);
                }
                clo.result(null);
                continue;
            }
            if (command instanceof WatchRangeKeysCommand) {
                watchCmd = (WatchRangeKeysCommand)command;
                IgniteUuid cursorId = watchCmd.getCursorId();
                Cursor<WatchEvent> cursor = this.storage.watch(watchCmd.keyFrom(), watchCmd.keyTo(), watchCmd.revision());
                this.cursors.put(cursorId, new CursorMeta(cursor, CursorType.WATCH, watchCmd.requesterNodeId(), null));
                clo.result((Serializable)cursorId);
                continue;
            }
            if (command instanceof WatchExactKeysCommand) {
                watchCmd = (WatchExactKeysCommand)command;
                IgniteUuid cursorId = watchCmd.getCursorId();
                Cursor<WatchEvent> cursor = this.storage.watch(watchCmd.keys(), (long)watchCmd.revision());
                this.cursors.put(cursorId, new CursorMeta(cursor, CursorType.WATCH, watchCmd.requesterNodeId(), null));
                clo.result((Serializable)cursorId);
                continue;
            }
            if (command instanceof CursorsCloseCommand) {
                CursorsCloseCommand cursorsCloseCmd = (CursorsCloseCommand)command;
                Iterator<CursorMeta> cursorsIter = this.cursors.values().iterator();
                while (cursorsIter.hasNext()) {
                    CursorMeta cursorDesc = cursorsIter.next();
                    if (!cursorDesc.requesterNodeId().equals(cursorsCloseCmd.nodeId())) continue;
                    try {
                        cursorDesc.cursor().close();
                    }
                    catch (Exception e) {
                        throw new MetaStorageException(ErrorGroups.MetaStorage.CURSOR_CLOSING_ERR, (Throwable)e);
                    }
                    cursorsIter.remove();
                }
                clo.result(null);
                continue;
            }
            assert (false) : "Command was not found [cmd=" + command + "]";
        }
    }

    public void onSnapshotSave(Path path, Consumer<Throwable> doneClo) {
        this.storage.snapshot(path).whenComplete((unused, throwable) -> doneClo.accept((Throwable)throwable));
    }

    public boolean onSnapshotLoad(Path path) {
        this.storage.restoreSnapshot(path);
        return true;
    }

    public void onShutdown() {
        try {
            this.storage.close();
        }
        catch (Exception e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.CLOSING_STORAGE_ERR, "Failed to close storage: " + e.getMessage(), (Throwable)e);
        }
    }

    @TestOnly
    public KeyValueStorage getStorage() {
        return this.storage;
    }

    private static If toIf(IfInfo iif) {
        return new If(MetaStorageListener.toCondition(iif.cond()), MetaStorageListener.toConditionBranch(iif.andThen()), MetaStorageListener.toConditionBranch(iif.orElse()));
    }

    private static Update toUpdate(UpdateInfo updateInfo) {
        return new Update(MetaStorageListener.toOperations(new ArrayList<OperationInfo>(updateInfo.operations())), new StatementResult(updateInfo.result().result()));
    }

    private static Statement toConditionBranch(StatementInfo statementInfo) {
        if (statementInfo.isTerminal()) {
            return new Statement(MetaStorageListener.toUpdate(statementInfo.update()));
        }
        return new Statement(MetaStorageListener.toIf(statementInfo.iif()));
    }

    private static Condition toCondition(ConditionInfo info) {
        if (info instanceof SimpleConditionInfo) {
            SimpleConditionInfo inf = (SimpleConditionInfo)info;
            byte[] key = inf.key();
            ConditionType type = inf.type();
            if (type == ConditionType.KEY_EXISTS) {
                return new ExistenceCondition(ExistenceCondition.Type.EXISTS, key);
            }
            if (type == ConditionType.KEY_NOT_EXISTS) {
                return new ExistenceCondition(ExistenceCondition.Type.NOT_EXISTS, key);
            }
            if (type == ConditionType.TOMBSTONE) {
                return new TombstoneCondition(key);
            }
            if (type == ConditionType.VAL_EQUAL) {
                return new ValueCondition(ValueCondition.Type.EQUAL, key, inf.value());
            }
            if (type == ConditionType.VAL_NOT_EQUAL) {
                return new ValueCondition(ValueCondition.Type.NOT_EQUAL, key, inf.value());
            }
            if (type == ConditionType.VAL_GREATER) {
                return new ValueCondition(ValueCondition.Type.GREATER, key, inf.value());
            }
            if (type == ConditionType.VAL_GREATER_OR_EQUAL) {
                return new ValueCondition(ValueCondition.Type.GREATER_OR_EQUAL, key, inf.value());
            }
            if (type == ConditionType.VAL_LESS) {
                return new ValueCondition(ValueCondition.Type.LESS, key, inf.value());
            }
            if (type == ConditionType.VAL_LESS_OR_EQUAL) {
                return new ValueCondition(ValueCondition.Type.LESS_OR_EQUAL, key, inf.value());
            }
            if (type == ConditionType.REV_EQUAL) {
                return new RevisionCondition(RevisionCondition.Type.EQUAL, key, inf.revision());
            }
            if (type == ConditionType.REV_NOT_EQUAL) {
                return new RevisionCondition(RevisionCondition.Type.NOT_EQUAL, key, inf.revision());
            }
            if (type == ConditionType.REV_GREATER) {
                return new RevisionCondition(RevisionCondition.Type.GREATER, key, inf.revision());
            }
            if (type == ConditionType.REV_GREATER_OR_EQUAL) {
                return new RevisionCondition(RevisionCondition.Type.GREATER_OR_EQUAL, key, inf.revision());
            }
            if (type == ConditionType.REV_LESS) {
                return new RevisionCondition(RevisionCondition.Type.LESS, key, inf.revision());
            }
            if (type == ConditionType.REV_LESS_OR_EQUAL) {
                return new RevisionCondition(RevisionCondition.Type.LESS_OR_EQUAL, key, inf.revision());
            }
            throw new IllegalArgumentException("Unknown condition type: " + type);
        }
        if (info instanceof CompoundConditionInfo) {
            CompoundConditionInfo inf = (CompoundConditionInfo)info;
            if (inf.type() == CompoundConditionType.AND) {
                return new AndCondition(MetaStorageListener.toCondition(inf.leftConditionInfo()), MetaStorageListener.toCondition(inf.rightConditionInfo()));
            }
            if (inf.type() == CompoundConditionType.OR) {
                return new OrCondition(MetaStorageListener.toCondition(inf.leftConditionInfo()), MetaStorageListener.toCondition(inf.rightConditionInfo()));
            }
            throw new IllegalArgumentException("Unknown compound condition " + inf.type());
        }
        throw new IllegalArgumentException("Unknown condition info type " + info);
    }

    private static List<Operation> toOperations(List<OperationInfo> infos) {
        ArrayList<Operation> ops = new ArrayList<Operation>(infos.size());
        for (OperationInfo info : infos) {
            ops.add(new Operation(info.type(), info.key(), info.value()));
        }
        return ops;
    }

    private static enum CursorType {
        RANGE,
        WATCH;

    }

    private class CursorMeta {
        private final Cursor<?> cursor;
        private final CursorType type;
        private final String requesterNodeId;
        @Nullable
        private final Integer batchSize;

        CursorMeta(Cursor<?> cursor, CursorType type, @Nullable String requesterNodeId, Integer batchSize) {
            this.cursor = cursor;
            this.type = type;
            this.requesterNodeId = requesterNodeId;
            this.batchSize = batchSize;
        }

        public Cursor<?> cursor() {
            return this.cursor;
        }

        public CursorType type() {
            return this.type;
        }

        public String requesterNodeId() {
            return this.requesterNodeId;
        }

        @Nullable
        public Integer batchSize() {
            return this.batchSize;
        }
    }
}

