/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.configuration;

import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.storage.pagememory.configuration.PageMemoryDataRegionName;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryDataStorageView;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineConfiguration;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineView;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryDataStorageView;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryStorageEngineConfiguration;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryStorageEngineView;

public class PageMemoryDataRegionValidatorImpl
implements Validator<PageMemoryDataRegionName, String> {
    public static final PageMemoryDataRegionValidatorImpl INSTANCE = new PageMemoryDataRegionValidatorImpl();

    public void validate(PageMemoryDataRegionName annotation, ValidationContext<String> ctx) {
        String dataRegionName = (String)ctx.getNewValue();
        Object newOwner = ctx.getNewOwner();
        if (newOwner instanceof InnerNode) {
            newOwner = ((InnerNode)newOwner).specificNode();
        }
        if (newOwner instanceof VolatilePageMemoryDataStorageView) {
            VolatilePageMemoryStorageEngineView engineConfig = (VolatilePageMemoryStorageEngineView)ctx.getNewRoot(VolatilePageMemoryStorageEngineConfiguration.KEY);
            assert (engineConfig != null);
            if (!PageMemoryDataRegionValidatorImpl.contains(engineConfig, dataRegionName)) {
                ctx.addIssue(PageMemoryDataRegionValidatorImpl.unableToFindDataRegionIssue(ctx.currentKey(), dataRegionName, VolatilePageMemoryStorageEngineConfiguration.KEY));
            }
        } else if (newOwner instanceof PersistentPageMemoryDataStorageView) {
            PersistentPageMemoryStorageEngineView engineConfig = (PersistentPageMemoryStorageEngineView)ctx.getNewRoot(PersistentPageMemoryStorageEngineConfiguration.KEY);
            assert (engineConfig != null);
            if (!PageMemoryDataRegionValidatorImpl.contains(engineConfig, dataRegionName)) {
                ctx.addIssue(PageMemoryDataRegionValidatorImpl.unableToFindDataRegionIssue(ctx.currentKey(), dataRegionName, PersistentPageMemoryStorageEngineConfiguration.KEY));
            }
        } else {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), String.format("Unknown data storage '%s'", newOwner)));
        }
    }

    private static boolean contains(VolatilePageMemoryStorageEngineView engineConfig, String dataRegionName) {
        return engineConfig.defaultRegion().name().equals(dataRegionName) || engineConfig.regions().get(dataRegionName) != null;
    }

    private static boolean contains(PersistentPageMemoryStorageEngineView engineConfig, String dataRegionName) {
        return engineConfig.defaultRegion().name().equals(dataRegionName) || engineConfig.regions().get(dataRegionName) != null;
    }

    private static ValidationIssue unableToFindDataRegionIssue(String validationKey, String dataRegionName, RootKey<?, ?> rootKey) {
        return new ValidationIssue(validationKey, String.format("Unable to find data region '%s' in configuration '%s'", dataRegionName, rootKey));
    }
}

