/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.ByteBufferRow;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;

public class CommandUtils {
    private static final IgniteLogger LOG = Loggers.forClass(CommandUtils.class);

    public static byte[] rowsToBytes(Collection<BinaryRow> rows) {
        Object object;
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (BinaryRow row : rows) {
                if (row == null) {
                    baos.write(CommandUtils.intToBytes(0));
                    continue;
                }
                byte[] bytes = CommandUtils.rowToBytes(row);
                baos.write(CommandUtils.intToBytes(bytes.length));
                baos.write(bytes);
            }
            baos.flush();
            object = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.debug("unable to write rows to stream [rowsCount={}]", (Throwable)e, new Object[]{rows.size()});
                throw new IgniteInternalException(ErrorGroups.Common.UNEXPECTED_ERR, (Throwable)e);
            }
        }
        baos.close();
        return object;
    }

    public static byte[] rowToBytes(@Nullable BinaryRow row) {
        byte[] byArray;
        if (row == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            row.writeTo((OutputStream)baos);
            baos.flush();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.debug("Unable to write row to stream [row={}]", (Throwable)e, new Object[]{row});
                throw new IgniteInternalException(ErrorGroups.Common.UNEXPECTED_ERR, (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    public static void readRows(byte[] bytes, Consumer<BinaryRow> consumer) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            int read;
            byte[] lenBytes = new byte[4];
            while ((read = bais.read(lenBytes)) != -1) {
                assert (read == 4);
                int len = CommandUtils.bytesToInt(lenBytes);
                if (len == 0) {
                    consumer.accept(null);
                    continue;
                }
                byte[] rowBytes = new byte[len];
                read = bais.read(rowBytes);
                assert (read == len);
                consumer.accept((BinaryRow)new ByteBufferRow(rowBytes));
            }
        }
        catch (IOException e) {
            LOG.debug("Unable to read rows from stream", (Throwable)e);
            throw new IgniteInternalException(ErrorGroups.Common.UNEXPECTED_ERR, (Throwable)e);
        }
    }

    public static byte[] rowMapToBytes(Map<RowId, BinaryRow> map) {
        byte[] byArray;
        if (map == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeInt(map.size());
                for (Map.Entry<RowId, BinaryRow> e : map.entrySet()) {
                    oos.writeShort((short)e.getKey().partitionId());
                    oos.writeLong(e.getKey().mostSignificantBits());
                    oos.writeLong(e.getKey().leastSignificantBits());
                    if (e.getValue() == null) {
                        oos.writeInt(0);
                        continue;
                    }
                    byte[] bytes = CommandUtils.rowToBytes(e.getValue());
                    oos.writeInt(bytes.length);
                    oos.write(bytes);
                }
            }
            baos.flush();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.debug("Unable to write the row map to stream [map={}]", (Throwable)e, new Object[]{map});
                throw new IgniteInternalException(ErrorGroups.Common.UNEXPECTED_ERR, (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    public static void readRowMap(byte[] bytes, BiConsumer<RowId, BinaryRow> consumer) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             ObjectInputStream ois = new ObjectInputStream(bais);){
            int size = ois.readInt();
            for (int i = 0; i < size; ++i) {
                int partId = ois.readShort() & 0xFFFF;
                long mostSignificantBits = ois.readLong();
                long leastSignificantBits = ois.readLong();
                RowId id = new RowId(partId, mostSignificantBits, leastSignificantBits);
                int len = ois.readInt();
                ByteBufferRow row = null;
                if (len != 0) {
                    byte[] rowBytes = new byte[len];
                    int read = ois.read(rowBytes);
                    assert (read == len);
                    row = new ByteBufferRow(rowBytes);
                }
                consumer.accept(id, (BinaryRow)row);
            }
        }
        catch (IOException e) {
            LOG.debug("Unable to read row map from stream [bytes={}]", (Throwable)e, new Object[]{bytes});
            throw new IgniteInternalException(ErrorGroups.Common.UNEXPECTED_ERR, (Throwable)e);
        }
    }

    private static byte[] intToBytes(int i) {
        byte[] arr = new byte[4];
        ByteBuffer.wrap(arr).putInt(i);
        return arr;
    }

    private static int bytesToInt(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }
}

