/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tostring;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.tostring.FieldDescriptor;

class ClassDescriptor {
    private final String sqn;
    private final String fqn;
    private final ArrayList<FieldDescriptor> fields = new ArrayList();

    ClassDescriptor(Class<?> cls) {
        assert (cls != null);
        this.fqn = cls.getName();
        this.sqn = cls.getSimpleName();
    }

    void addField(FieldDescriptor field) {
        assert (field != null);
        this.fields.add(field);
    }

    void sortFields() {
        this.fields.trimToSize();
        this.fields.sort(Comparator.comparingInt(FieldDescriptor::getOrder));
    }

    String getSimpleClassName() {
        return this.sqn;
    }

    String getFullyQualifiedClassName() {
        return this.fqn;
    }

    List<FieldDescriptor> getFields() {
        return this.fields;
    }
}

