/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.recovery;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.configuration.notifications.ConfigurationStorageRevisionListener;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.IgniteSystemProperties;

public class ConfigurationCatchUpListener
implements ConfigurationStorageRevisionListener {
    public static final String CONFIGURATION_CATCH_UP_DIFFERENCE_PROPERTY = "CONFIGURATION_CATCH_UP_DIFFERENCE";
    private final int configurationCatchUpDifference = IgniteSystemProperties.getInteger((String)"CONFIGURATION_CATCH_UP_DIFFERENCE", (int)100);
    private volatile long targetRevision = -1L;
    private final CompletableFuture<Void> catchUpFuture;
    private final ConfigurationStorage cfgStorage;
    private final Object targetRevisionUpdateMutex = new Object();
    private final IgniteLogger log;

    public ConfigurationCatchUpListener(ConfigurationStorage cfgStorage, CompletableFuture<Void> catchUpFuture, IgniteLogger log) {
        this.cfgStorage = cfgStorage;
        this.catchUpFuture = catchUpFuture;
        this.log = log;
    }

    private boolean isConfigurationUpToDate(long targetRevision, long appliedRevision) {
        return targetRevision - (long)this.configurationCatchUpDifference <= appliedRevision;
    }

    private CompletableFuture<?> checkRevisionUpToDate(long appliedRevision) {
        return this.cfgStorage.lastRevision().thenAccept(rev -> {
            Object object = this.targetRevisionUpdateMutex;
            synchronized (object) {
                assert (rev >= appliedRevision) : IgniteStringFormatter.format((String)"Configuration revision must be greater than local node applied revision [msRev={}, appliedRev={}", (Object[])new Object[]{rev, appliedRevision});
                this.targetRevision = rev;
                this.log.info("Checking revision on recovery [targetRevision={}, appliedRevision={}, acceptableDifference={}]", new Object[]{this.targetRevision, appliedRevision, this.configurationCatchUpDifference});
                if (this.isConfigurationUpToDate(this.targetRevision, appliedRevision)) {
                    this.catchUpFuture.complete(null);
                }
            }
        });
    }

    public CompletableFuture<?> onUpdate(long appliedRevision) {
        long targetRev = this.targetRevision;
        if (targetRev >= 0L) {
            if (this.isConfigurationUpToDate(targetRev, appliedRevision)) {
                return this.checkRevisionUpToDate(appliedRevision);
            }
        } else {
            return this.checkRevisionUpToDate(appliedRevision);
        }
        return CompletableFuture.completedFuture(null);
    }
}

