/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.basic;

import java.util.Arrays;
import org.apache.ignite.internal.storage.DataRow;
import org.apache.ignite.internal.storage.InvokeClosure;
import org.apache.ignite.internal.storage.OperationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceExactInvokeClosure
implements InvokeClosure<Boolean> {
    @NotNull
    private final DataRow expectedRow;
    @NotNull
    private final DataRow newRow;
    private boolean replaces;

    public ReplaceExactInvokeClosure(@NotNull DataRow expectedRow, @NotNull DataRow newRow) {
        this.expectedRow = expectedRow;
        this.newRow = newRow;
    }

    @Override
    public void call(@Nullable DataRow row) {
        this.replaces = row != null && Arrays.equals(row.valueBytes(), this.expectedRow.valueBytes());
    }

    @Override
    @Nullable
    public DataRow newRow() {
        return this.newRow;
    }

    @Override
    @Nullable
    public OperationType operationType() {
        return this.replaces ? OperationType.WRITE : OperationType.NOOP;
    }

    @Override
    @NotNull
    public Boolean result() {
        return this.replaces;
    }
}

