/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.configuration;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.schema.configuration.storage.ExistingDataStorage;
import org.apache.ignite.internal.storage.DataStorageModule;

public class ExistingDataStorageValidator
implements Validator<ExistingDataStorage, String> {
    private final Set<String> dataStorages;

    public ExistingDataStorageValidator(Iterable<DataStorageModule> modules) {
        this.dataStorages = Stream.concat(Stream.of("unknown"), StreamSupport.stream(modules.spliterator(), false).map(DataStorageModule::name)).collect(Collectors.toUnmodifiableSet());
    }

    public void validate(ExistingDataStorage annotation, ValidationContext<String> ctx) {
        String newValue = (String)ctx.getNewValue();
        if (!this.dataStorages.contains(newValue)) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), String.format("Non-existent data storage [dataStorage=%s, existDataStorages=%s, key=%s]", newValue, this.dataStorages, ctx.currentKey())));
        }
    }
}

