/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.monitor;

import io.scalecube.cluster.Member;
import io.scalecube.cluster.monitor.ClusterMonitorMBean;
import io.scalecube.cluster.monitor.ClusterMonitorModel;
import io.scalecube.net.Address;
import java.util.Optional;
import java.util.stream.Collectors;

public class JmxClusterMonitorMBean
implements ClusterMonitorMBean {
    private final ClusterMonitorModel monitorModel;

    public JmxClusterMonitorMBean(ClusterMonitorModel monitorModel) {
        this.monitorModel = monitorModel;
    }

    @Override
    public String getClusterConfig() {
        return String.valueOf(this.monitorModel.config());
    }

    @Override
    public int getClusterSize() {
        return this.monitorModel.clusterSize();
    }

    @Override
    public int getMemberIncarnation() {
        return this.monitorModel.incarnation();
    }

    @Override
    public String getMember() {
        return String.valueOf(this.monitorModel.member());
    }

    @Override
    public String getMetadata() {
        return String.valueOf(Optional.ofNullable(this.monitorModel.metadata()).map(Object::toString).orElse(null));
    }

    @Override
    public String getSeedMembers() {
        return this.monitorModel.seedMembers().stream().map(Address::toString).collect(Collectors.joining(",", "[", "]"));
    }

    @Override
    public String getAliveMembers() {
        return this.monitorModel.aliveMembers().stream().map(Member::toString).collect(Collectors.joining(",", "[", "]"));
    }

    @Override
    public String getSuspectedMembers() {
        return this.monitorModel.suspectedMembers().stream().map(Member::toString).collect(Collectors.joining(",", "[", "]"));
    }

    @Override
    public String getRemovedMembers() {
        return this.monitorModel.removedMembers().stream().map(Member::toString).collect(Collectors.joining(",", "[", "]"));
    }
}

