/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.direct.DirectMarshallingUtils;
import org.apache.ignite.internal.network.direct.DirectMessageReader;
import org.apache.ignite.internal.network.message.ClassDescriptorListMessage;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageReader;

public class InboundDecoder
extends ByteToMessageDecoder {
    public static final String NAME = "inbound-decoder";
    private static final IgniteLogger LOG = Loggers.forClass(InboundDecoder.class);
    private static final AttributeKey<MessageReader> READER_KEY = AttributeKey.valueOf((String)"READER");
    private static final AttributeKey<MessageDeserializer<NetworkMessage>> DESERIALIZER_KEY = AttributeKey.valueOf((String)"DESERIALIZER");
    private final PerSessionSerializationService serializationService;

    public InboundDecoder(PerSessionSerializationService serializationService) {
        this.serializationService = serializationService;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        ByteBuffer buffer = in.nioBuffer();
        Attribute readerAttr = ctx.channel().attr(READER_KEY);
        MessageReader reader = (MessageReader)readerAttr.get();
        if (reader == null) {
            reader = new DirectMessageReader(this.serializationService, 1);
            readerAttr.set((Object)reader);
        }
        Attribute messageAttr = ctx.channel().attr(DESERIALIZER_KEY);
        while (buffer.hasRemaining()) {
            int initialNioBufferPosition = buffer.position();
            MessageDeserializer msg = (MessageDeserializer)messageAttr.get();
            try {
                if (msg == null) {
                    if (buffer.remaining() < 4) break;
                    msg = this.serializationService.createMessageDeserializer(DirectMarshallingUtils.getShort(buffer), DirectMarshallingUtils.getShort(buffer));
                }
                boolean finished = false;
                if (msg != null && buffer.hasRemaining()) {
                    reader.setCurrentReadClass(msg.klass());
                    reader.setBuffer(buffer);
                    finished = msg.readMessage(reader);
                }
                int readBytes = buffer.position() - initialNioBufferPosition;
                in.readerIndex(in.readerIndex() + readBytes);
                if (finished) {
                    reader.reset();
                    messageAttr.set(null);
                    NetworkMessage message = msg.getMessage();
                    if (message instanceof ClassDescriptorListMessage) {
                        this.onClassDescriptorMessage((ClassDescriptorListMessage)message);
                    } else {
                        out.add(message);
                    }
                } else {
                    messageAttr.set(msg);
                }
                if (readBytes != 0) continue;
                break;
            }
            catch (Throwable e) {
                LOG.debug("Failed to read message [msg={}, buf={}, reader={}, reason={}]", e, new Object[]{msg, buffer, reader, e.getMessage()});
                throw e;
            }
        }
    }

    private void onClassDescriptorMessage(ClassDescriptorListMessage msg) {
        this.serializationService.mergeDescriptors(msg.messages());
    }
}

