/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.function.Consumer;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessage;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.network.NetworkMessage;

public class MessageHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "message-handler";
    private final Consumer<InNetworkObject> messageListener;
    private final String consistentId;
    private final PerSessionSerializationService serializationService;

    public MessageHandler(Consumer<InNetworkObject> messageListener, String consistentId, PerSessionSerializationService serializationService) {
        this.messageListener = messageListener;
        this.consistentId = consistentId;
        this.serializationService = serializationService;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        NetworkMessage message = (NetworkMessage)msg;
        if (message instanceof AcknowledgementMessage) {
            return;
        }
        this.messageListener.accept(new InNetworkObject(message, this.consistentId, this.serializationService.compositeDescriptorRegistry()));
    }
}

