/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.internal.network.serialization.BuiltInType;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.ClassDescriptorFactory;
import org.apache.ignite.internal.network.serialization.ClassDescriptorRegistry;
import org.apache.ignite.internal.network.serialization.DeclaredType;
import org.apache.ignite.internal.network.serialization.DescriptorRegistry;
import org.apache.ignite.internal.network.serialization.marshal.BuiltInContainerMarshallers;
import org.apache.ignite.internal.network.serialization.marshal.BuiltInNonContainerMarshallers;
import org.apache.ignite.internal.network.serialization.marshal.DescribedObject;
import org.apache.ignite.internal.network.serialization.marshal.ExternalizableMarshaller;
import org.apache.ignite.internal.network.serialization.marshal.FlaggedObjectIds;
import org.apache.ignite.internal.network.serialization.marshal.LocalDescriptors;
import org.apache.ignite.internal.network.serialization.marshal.MarshalException;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.MarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.MarshallingValidations;
import org.apache.ignite.internal.network.serialization.marshal.ProtocolMarshalling;
import org.apache.ignite.internal.network.serialization.marshal.ProxyMarshaller;
import org.apache.ignite.internal.network.serialization.marshal.ReadResolver;
import org.apache.ignite.internal.network.serialization.marshal.SchemaMismatchEventSource;
import org.apache.ignite.internal.network.serialization.marshal.SchemaMismatchException;
import org.apache.ignite.internal.network.serialization.marshal.SchemaMismatchHandler;
import org.apache.ignite.internal.network.serialization.marshal.SchemaMismatchHandlers;
import org.apache.ignite.internal.network.serialization.marshal.StructuredObjectMarshaller;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshalException;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.UosIgniteOutputStream;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.network.serialization.marshal.WriteReplacer;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.util.io.IgniteUnsafeDataInput;
import org.jetbrains.annotations.Nullable;

public class DefaultUserObjectMarshaller
implements UserObjectMarshaller,
SchemaMismatchEventSource {
    private static final boolean UNSHARED = true;
    private static final boolean NOT_UNSHARED = false;
    private static final DeclaredType NO_DECLARED_TYPE = null;
    private final SchemaMismatchHandlers schemaMismatchHandlers = new SchemaMismatchHandlers();
    private final LocalDescriptors localDescriptors;
    private final WriteReplacer writeReplacer;
    private final ReadResolver readResolver;
    private final BuiltInNonContainerMarshallers builtInNonContainerMarshallers = new BuiltInNonContainerMarshallers();
    private final BuiltInContainerMarshallers builtInContainerMarshallers = new BuiltInContainerMarshallers(this::marshalShared, this::unmarshalShared);
    private final StructuredObjectMarshaller structuredObjectMarshaller;
    private final ExternalizableMarshaller externalizableMarshaller;
    private final ProxyMarshaller proxyMarshaller;
    private final MarshallingValidations validations = new MarshallingValidations();
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private final ThreadLocal<UosIgniteOutputStream> threadLocalDataOutput = ThreadLocal.withInitial(this::newOutput);

    private UosIgniteOutputStream newOutput() {
        return new UosIgniteOutputStream(4096);
    }

    public DefaultUserObjectMarshaller(ClassDescriptorRegistry localRegistry, ClassDescriptorFactory descriptorFactory) {
        this.localDescriptors = new LocalDescriptors(localRegistry, descriptorFactory);
        this.writeReplacer = new WriteReplacer(this.localDescriptors);
        this.readResolver = new ReadResolver(this.schemaMismatchHandlers);
        this.structuredObjectMarshaller = new StructuredObjectMarshaller(localRegistry, this::marshalShared, this::marshalUnshared, this::unmarshalShared, this::unmarshalUnshared, this.schemaMismatchHandlers);
        this.externalizableMarshaller = new ExternalizableMarshaller(this::marshalShared, this::marshalUnshared, this::unmarshalShared, this::unmarshalUnshared, this.structuredObjectMarshaller, this.schemaMismatchHandlers);
        this.proxyMarshaller = new ProxyMarshaller(this::marshalShared, this::unmarshalShared);
    }

    public MarshalledObject marshal(@Nullable Object object) throws MarshalException {
        MarshallingContext context = new MarshallingContext();
        UosIgniteOutputStream output = this.freshByteArrayOutputStream();
        try {
            this.marshalShared(object, (IgniteDataOutput)output, context);
        }
        catch (IOException e) {
            throw new MarshalException("Cannot marshal", (Throwable)e);
        }
        finally {
            output.release();
        }
        return new MarshalledObject(output.array(), context.usedDescriptorIds());
    }

    private UosIgniteOutputStream freshByteArrayOutputStream() {
        UosIgniteOutputStream output = this.threadLocalDataOutput.get();
        if (output.isOccupied()) {
            output = this.newOutput();
        } else {
            output.cleanup();
        }
        output.occupy();
        return output;
    }

    private void marshalShared(@Nullable Object object, IgniteDataOutput output, MarshallingContext context) throws MarshalException, IOException {
        this.marshalShared(object, NO_DECLARED_TYPE, output, context);
    }

    private void marshalShared(@Nullable Object object, @Nullable DeclaredType declaredType, IgniteDataOutput output, MarshallingContext context) throws MarshalException, IOException {
        this.marshalToOutput(object, declaredType, output, context, false);
    }

    private void marshalUnshared(@Nullable Object object, DeclaredType declaredType, IgniteDataOutput output, MarshallingContext context) throws MarshalException, IOException {
        this.marshalToOutput(object, declaredType, output, context, true);
    }

    private void marshalToOutput(@Nullable Object object, @Nullable DeclaredType declaredType, IgniteDataOutput output, MarshallingContext context, boolean unshared) throws MarshalException, IOException {
        this.validations.throwIfMarshallingNotSupported(object);
        ClassDescriptor originalDescriptor = this.localDescriptors.getOrCreateDescriptor(object);
        DescribedObject afterReplacement = this.writeReplacer.applyWriteReplaceIfNeeded(object, originalDescriptor);
        if (this.hasObjectIdentity(afterReplacement.object, afterReplacement.descriptor)) {
            long flaggedObjectId = context.memorizeObject(afterReplacement.object, unshared);
            int objectId = FlaggedObjectIds.objectId(flaggedObjectId);
            if (FlaggedObjectIds.isAlreadySeen(flaggedObjectId)) {
                this.writeReference(objectId, declaredType, (DataOutput)output);
            } else {
                this.marshalIdentifiable(afterReplacement.object, afterReplacement.descriptor, declaredType, objectId, output, context);
            }
        } else {
            this.marshalValue(afterReplacement.object, afterReplacement.descriptor, declaredType, output, context);
        }
    }

    private boolean hasObjectIdentity(@Nullable Object object, ClassDescriptor descriptor) {
        return object != null && this.mayHaveObjectIdentity(descriptor);
    }

    private boolean mayHaveObjectIdentity(ClassDescriptor descriptor) {
        return !descriptor.isPrimitive() && !descriptor.isNull();
    }

    private void writeReference(int objectId, @Nullable DeclaredType declaredClass, DataOutput output) throws IOException {
        if (!this.runtimeTypeIsKnownUpfront(declaredClass)) {
            ProtocolMarshalling.writeDescriptorOrCommandId(BuiltInType.REFERENCE.descriptorId(), output);
        }
        ProtocolMarshalling.writeObjectId(objectId, output);
    }

    private void marshalIdentifiable(Object object, ClassDescriptor descriptor, @Nullable DeclaredType declaredType, int objectId, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        if (!this.runtimeTypeIsKnownUpfront(declaredType)) {
            this.writeDescriptorId(descriptor, (DataOutput)output);
        }
        ProtocolMarshalling.writeObjectId(objectId, (DataOutput)output);
        this.writeObject(object, descriptor, output, context);
    }

    private boolean runtimeTypeIsKnownUpfront(@Nullable DeclaredType declaredType) {
        return declaredType != null && declaredType.isRuntimeTypeKnownUpfront();
    }

    private void writeDescriptorId(ClassDescriptor descriptor, DataOutput output) throws IOException {
        ProtocolMarshalling.writeDescriptorOrCommandId(descriptor.descriptorId(), output);
    }

    private void marshalValue(Object object, ClassDescriptor descriptor, DeclaredType declaredType, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        if (!this.runtimeTypeIsKnownUpfront(declaredType)) {
            this.writeDescriptorId(descriptor, (DataOutput)output);
        }
        this.writeObject(object, descriptor, output, context);
    }

    private void writeObject(@Nullable Object object, ClassDescriptor descriptor, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        if (this.isBuiltInNonContainer(descriptor)) {
            this.builtInNonContainerMarshallers.writeBuiltIn(object, descriptor, output, context);
        } else if (this.isBuiltInCollection(descriptor)) {
            this.builtInContainerMarshallers.writeBuiltInCollection((Collection)object, descriptor, output, context);
        } else if (this.isBuiltInMap(descriptor)) {
            this.builtInContainerMarshallers.writeBuiltInMap((Map)object, descriptor, output, context);
        } else if (descriptor.isArray()) {
            this.builtInContainerMarshallers.writeGenericRefArray((Object[])object, descriptor, output, context);
        } else if (descriptor.isExternalizable()) {
            this.externalizableMarshaller.writeExternalizable((Externalizable)object, descriptor, output, context);
        } else if (descriptor.isProxy()) {
            this.proxyMarshaller.writeProxy(object, output, context);
        } else {
            this.structuredObjectMarshaller.writeStructuredObject(object, descriptor, output, context);
        }
    }

    private boolean isBuiltInNonContainer(ClassDescriptor descriptor) {
        return this.builtInNonContainerMarshallers.supports(descriptor);
    }

    private boolean isBuiltInCollection(ClassDescriptor descriptor) {
        return this.builtInContainerMarshallers.supportsCollection(descriptor);
    }

    private boolean isBuiltInMap(ClassDescriptor descriptor) {
        return this.builtInContainerMarshallers.supportsAsBuiltInMap(descriptor);
    }

    @Nullable
    public <T> T unmarshal(byte[] bytes, Object mergedDescriptors) throws UnmarshalException {
        IgniteUnsafeDataInput input = new IgniteUnsafeDataInput(bytes);
        try {
            UnmarshallingContext context = new UnmarshallingContext((IgniteDataInput)input, (DescriptorRegistry)mergedDescriptors, this.classLoader);
            T result = this.unmarshalShared((IgniteDataInput)input, context);
            this.throwIfNotDrained((InputStream)input);
            return result;
        }
        catch (IOException e) {
            throw new UnmarshalException("Cannot unmarshal", (Throwable)e);
        }
    }

    private <T> T unmarshalShared(IgniteDataInput input, UnmarshallingContext context) throws IOException, UnmarshalException {
        return this.unmarshalShared(input, NO_DECLARED_TYPE, context);
    }

    private <T> T unmarshalShared(IgniteDataInput input, @Nullable DeclaredType declaredType, UnmarshallingContext context) throws IOException, UnmarshalException {
        return this.unmarshalFromInput(input, declaredType, context, false);
    }

    private <T> T unmarshalUnshared(IgniteDataInput input, @Nullable DeclaredType declaredType, UnmarshallingContext context) throws IOException, UnmarshalException {
        return this.unmarshalFromInput(input, declaredType, context, true);
    }

    private <T> T unmarshalFromInput(IgniteDataInput input, @Nullable DeclaredType declaredType, UnmarshallingContext context, boolean unshared) throws IOException, UnmarshalException {
        int objectId;
        ClassDescriptor remoteDescriptor = this.resolveDescriptor(input, declaredType, context);
        if (this.mayHaveObjectIdentity(remoteDescriptor) && context.isKnownObjectId(objectId = this.peekObjectId((DataInput)input, context))) {
            return this.unmarshalReference((DataInput)input, context, unshared);
        }
        Object readObject = this.readObject(input, context, remoteDescriptor, unshared);
        return (T)this.readResolver.applyReadResolveIfNeeded(readObject, remoteDescriptor);
    }

    private ClassDescriptor resolveDescriptor(IgniteDataInput input, @Nullable DeclaredType declaredType, UnmarshallingContext context) throws IOException {
        if (this.runtimeTypeIsKnownUpfront(declaredType)) {
            return context.getRequiredDescriptor(declaredType.typeDescriptorId());
        }
        int commandOrDescriptorId = ProtocolMarshalling.readDescriptorOrCommandId((DataInput)input);
        return context.getRequiredDescriptor(commandOrDescriptorId);
    }

    private int peekObjectId(DataInput input, UnmarshallingContext context) throws IOException {
        context.markSource(4);
        int objectId = ProtocolMarshalling.readObjectId(input);
        context.resetSourceToMark();
        return objectId;
    }

    private <T> T unmarshalReference(DataInput input, UnmarshallingContext context, boolean unshared) throws IOException {
        if (unshared) {
            throw new InvalidObjectException("cannot read back reference as unshared");
        }
        int objectId = ProtocolMarshalling.readObjectId(input);
        if (context.isUnsharedObjectId(objectId)) {
            throw new InvalidObjectException("cannot read back reference to unshared object");
        }
        return context.dereference(objectId);
    }

    @Nullable
    private Object readObject(IgniteDataInput input, UnmarshallingContext context, ClassDescriptor remoteDescriptor, boolean unshared) throws IOException, UnmarshalException {
        if (!this.mayHaveObjectIdentity(remoteDescriptor)) {
            return this.readValue(input, remoteDescriptor, context);
        }
        if (this.mustBeReadInOneStage(remoteDescriptor)) {
            return this.readIdentifiableInOneStage(input, remoteDescriptor, context, unshared);
        }
        return this.readIdentifiableInTwoStages(input, remoteDescriptor, context, unshared);
    }

    private boolean mustBeReadInOneStage(ClassDescriptor descriptor) {
        return this.builtInNonContainerMarshallers.supports(descriptor);
    }

    @Nullable
    private Object readIdentifiableInOneStage(IgniteDataInput input, ClassDescriptor descriptor, UnmarshallingContext context, boolean unshared) throws IOException, UnmarshalException {
        int objectId = this.readObjectId((DataInput)input);
        Object object = this.readValue(input, descriptor, context);
        context.registerReference(objectId, object, unshared);
        return object;
    }

    private int readObjectId(DataInput input) throws IOException {
        return ProtocolMarshalling.readObjectId(input);
    }

    private Object readIdentifiableInTwoStages(IgniteDataInput input, ClassDescriptor remoteDescriptor, UnmarshallingContext context, boolean unshared) throws IOException, UnmarshalException {
        int objectId = this.readObjectId((DataInput)input);
        Object object = this.preInstantiate(remoteDescriptor, input, context);
        context.registerReference(objectId, object, unshared);
        this.fillObjectFrom(input, object, remoteDescriptor, context);
        return object;
    }

    private Object preInstantiate(ClassDescriptor remoteDescriptor, IgniteDataInput input, UnmarshallingContext context) throws IOException, UnmarshalException {
        if (this.isBuiltInNonContainer(remoteDescriptor)) {
            throw new IllegalStateException("Should not be here, descriptor is " + remoteDescriptor);
        }
        if (this.isBuiltInCollection(remoteDescriptor)) {
            return this.builtInContainerMarshallers.preInstantiateBuiltInMutableCollection(remoteDescriptor, (DataInput)input, context);
        }
        if (this.isBuiltInMap(remoteDescriptor)) {
            return this.builtInContainerMarshallers.preInstantiateBuiltInMutableMap(remoteDescriptor, (DataInput)input, context);
        }
        if (remoteDescriptor.isArray()) {
            return this.builtInContainerMarshallers.preInstantiateGenericRefArray((DataInput)input, context);
        }
        if (remoteDescriptor.isExternalizable()) {
            return this.externalizableMarshaller.preInstantiateExternalizable(remoteDescriptor);
        }
        if (remoteDescriptor.isProxy()) {
            return this.proxyMarshaller.preInstantiateProxy(input, context);
        }
        return this.structuredObjectMarshaller.preInstantiateStructuredObject(remoteDescriptor);
    }

    private void fillObjectFrom(IgniteDataInput input, Object objectToFill, ClassDescriptor remoteDescriptor, UnmarshallingContext context) throws UnmarshalException, IOException {
        if (this.isBuiltInNonContainer(remoteDescriptor)) {
            throw new IllegalStateException("Cannot fill " + remoteDescriptor.className() + ", this is a programmatic error");
        }
        if (this.isBuiltInCollection(remoteDescriptor)) {
            this.fillBuiltInCollectionFrom(input, (Collection)objectToFill, remoteDescriptor, context);
        } else if (this.isBuiltInMap(remoteDescriptor)) {
            this.fillBuiltInMapFrom(input, (Map)objectToFill, context);
        } else if (remoteDescriptor.isArray()) {
            this.fillGenericRefArrayFrom(input, (Object[])objectToFill, remoteDescriptor, context);
        } else if (remoteDescriptor.isExternalizable()) {
            this.externalizableMarshaller.fillFromRemotelyExternalizable(input, objectToFill, context);
        } else if (remoteDescriptor.isProxy()) {
            this.proxyMarshaller.fillProxyFrom(input, objectToFill, context);
        } else {
            this.structuredObjectMarshaller.fillStructuredObjectFrom(input, objectToFill, remoteDescriptor, context);
            this.fireExternalizableMissedIfExternalizableLocally(objectToFill);
        }
    }

    private void fillBuiltInCollectionFrom(IgniteDataInput input, Collection<?> collectionToFill, ClassDescriptor descriptor, UnmarshallingContext context) throws UnmarshalException, IOException {
        this.builtInContainerMarshallers.fillBuiltInCollectionFrom(input, collectionToFill, descriptor, this::unmarshalShared, context);
    }

    private void fillBuiltInMapFrom(IgniteDataInput input, Map<?, ?> mapToFill, UnmarshallingContext context) throws UnmarshalException, IOException {
        this.builtInContainerMarshallers.fillBuiltInMapFrom(input, mapToFill, this::unmarshalShared, this::unmarshalShared, context);
    }

    private void fillGenericRefArrayFrom(IgniteDataInput input, Object[] array, ClassDescriptor arrayDescriptor, UnmarshallingContext context) throws IOException, UnmarshalException {
        this.builtInContainerMarshallers.fillGenericRefArrayFrom(input, array, arrayDescriptor, context);
    }

    @Nullable
    private Object readValue(IgniteDataInput input, ClassDescriptor descriptor, UnmarshallingContext context) throws IOException, UnmarshalException {
        if (this.isBuiltInNonContainer(descriptor)) {
            return this.builtInNonContainerMarshallers.readBuiltIn(descriptor, input, context);
        }
        throw new IllegalStateException("Cannot read an instance of " + descriptor.className() + ", this is a programmatic error");
    }

    private void throwIfNotDrained(InputStream dis) throws IOException, UnmarshalException {
        if (dis.available() > 0) {
            throw new UnmarshalException("After reading a value, " + dis.available() + " excessive byte(s) still remain");
        }
    }

    private void fireExternalizableMissedIfExternalizableLocally(Object objectToFill) throws SchemaMismatchException {
        if (objectToFill instanceof Externalizable) {
            this.schemaMismatchHandlers.onExternalizableMissed(objectToFill);
        }
    }

    @Override
    public <T> void replaceSchemaMismatchHandler(Class<T> layerClass, SchemaMismatchHandler<T> handler) {
        this.schemaMismatchHandlers.registerHandler(layerClass, handler);
    }

    @Override
    public <T> void replaceSchemaMismatchHandler(String layerClassName, SchemaMismatchHandler<T> handler) {
        this.schemaMismatchHandlers.registerHandler(layerClassName, handler);
    }
}

