/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.websocket;

import io.micronaut.http.MediaType;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public interface WebSocketBroadcaster {
    public <T> Publisher<T> broadcast(T var1, MediaType var2, Predicate<WebSocketSession> var3);

    default public <T> Publisher<T> broadcast(T message, MediaType mediaType) {
        return this.broadcast(message, mediaType, s -> true);
    }

    default public <T> Publisher<T> broadcast(T message) {
        return this.broadcast(message, MediaType.APPLICATION_JSON_TYPE, s -> true);
    }

    default public <T> Publisher<T> broadcast(T message, Predicate<WebSocketSession> filter) {
        Objects.requireNonNull(filter, "The filter cannot be null");
        return this.broadcast(message, MediaType.APPLICATION_JSON_TYPE, filter);
    }

    default public <T> CompletableFuture<T> broadcastAsync(T message, MediaType mediaType, Predicate<WebSocketSession> filter) {
        CompletableFuture future = new CompletableFuture();
        Flux.from(this.broadcast(message, mediaType, filter)).subscribe(o -> {}, future::completeExceptionally, () -> future.complete(message));
        return future;
    }

    default public <T> CompletableFuture<T> broadcastAsync(T message) {
        return this.broadcastAsync(message, MediaType.APPLICATION_JSON_TYPE, o -> true);
    }

    default public <T> CompletableFuture<T> broadcastAsync(T message, Predicate<WebSocketSession> filter) {
        return this.broadcastAsync(message, MediaType.APPLICATION_JSON_TYPE, filter);
    }

    default public <T> CompletableFuture<T> broadcastAsync(T message, MediaType mediaType) {
        return this.broadcastAsync(message, mediaType, o -> true);
    }

    default public <T> void broadcastSync(T message, MediaType mediaType, Predicate<WebSocketSession> filter) {
        try {
            this.broadcastAsync(message, mediaType, filter).get();
        }
        catch (InterruptedException e) {
            throw new WebSocketSessionException("Broadcast Interrupted");
        }
        catch (ExecutionException e) {
            throw new WebSocketSessionException("Broadcast Failure: " + e.getMessage(), e);
        }
    }

    default public <T> void broadcastSync(T message) {
        this.broadcastSync(message, MediaType.APPLICATION_JSON_TYPE, o -> true);
    }

    default public <T> void broadcastSync(T message, Predicate<WebSocketSession> filter) {
        this.broadcastSync(message, MediaType.APPLICATION_JSON_TYPE, filter);
    }

    default public <T> void broadcastSync(T message, MediaType mediaType) {
        this.broadcastSync(message, mediaType, o -> true);
    }
}

