/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.tostring.S;

public class BitmaskNativeType
extends NativeType {
    private final int bits;

    protected BitmaskNativeType(int bits) {
        super(NativeTypeSpec.BITMASK, Math.max(1, (bits + 7) / 8));
        this.bits = bits;
    }

    public int bits() {
        return this.bits;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmaskNativeType that = (BitmaskNativeType)o;
        return this.bits == that.bits;
    }

    @Override
    public int hashCode() {
        return this.bits;
    }

    @Override
    public int compareTo(NativeType o) {
        int res = super.compareTo(o);
        if (res == 0) {
            BitmaskNativeType that = (BitmaskNativeType)o;
            return Integer.compare(this.bits, that.bits);
        }
        return res;
    }

    @Override
    public String toString() {
        return S.toString((String)BitmaskNativeType.class.getSimpleName(), (String)"bits", (Object)this.bits, (String)"typeSpec", (Object)((Object)this.spec()), (String)"len", (Object)this.sizeInBytes());
    }
}

