/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlCreateTable
extends SqlCreate {
    private final SqlIdentifier name;
    private final @Nullable SqlIdentifier engineName;
    private final @Nullable SqlNodeList columnList;
    private final @Nullable SqlNodeList colocationColumns;
    private final @Nullable SqlNodeList createOptionList;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);

    public IgniteSqlCreateTable(SqlParserPos pos, boolean ifNotExists, SqlIdentifier name, @Nullable SqlIdentifier engineName, @Nullable SqlNodeList columnList, @Nullable SqlNodeList colocationColumns, @Nullable SqlNodeList createOptionList) {
        super(OPERATOR, pos, false, ifNotExists);
        assert (engineName == null || engineName.isSimple()) : engineName;
        this.name = Objects.requireNonNull(name, "name");
        this.engineName = engineName;
        this.columnList = columnList;
        this.colocationColumns = colocationColumns;
        this.createOptionList = createOptionList;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columnList, (Object)this.createOptionList);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame;
        writer.keyword("CREATE");
        writer.keyword("TABLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        if (this.colocationColumns != null) {
            writer.keyword("COLOCATE BY");
            frame = writer.startList("(", ")");
            this.colocationColumns.unparse(writer, 0, 0);
            writer.endList(frame);
        }
        if (this.engineName != null) {
            writer.keyword("ENGINE");
            this.engineName.unparse(writer, 0, 0);
        }
        if (this.createOptionList != null) {
            writer.keyword("WITH");
            this.createOptionList.unparse(writer, 0, 0);
        }
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public @Nullable SqlIdentifier engineName() {
        return this.engineName;
    }

    public SqlNodeList columnList() {
        return this.columnList;
    }

    public SqlNodeList colocationColumns() {
        return this.colocationColumns;
    }

    public SqlNodeList createOptionList() {
        return this.createOptionList;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }
}

