/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.trait;

import java.util.Collection;
import java.util.List;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.apache.ignite.internal.sql.engine.trait.Destination;

public final class Partitioned<RowT>
implements Destination<RowT> {
    private final List<List<String>> assignments;
    private final ToIntFunction<RowT> partFun;

    public Partitioned(List<List<String>> assignments, ToIntFunction<RowT> partFun) {
        this.assignments = assignments;
        this.partFun = partFun;
    }

    @Override
    public List<String> targets(RowT row) {
        return this.assignments.get(this.partFun.applyAsInt(row) % this.assignments.size());
    }

    @Override
    public List<String> targets() {
        return this.assignments.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }
}

