/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb.index;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.IndexRow;
import org.apache.ignite.internal.storage.index.IndexRowImpl;
import org.apache.ignite.internal.storage.index.SortedIndexDescriptor;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.storage.rocksdb.RocksDbMvPartitionStorage;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.CursorUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatchWithIndex;

public class RocksDbSortedIndexStorage
implements SortedIndexStorage {
    private static final int ROW_ID_SIZE = 16;
    private static final ByteOrder ORDER = ByteOrder.BIG_ENDIAN;
    private final SortedIndexDescriptor descriptor;
    private final ColumnFamily indexCf;
    private final RocksDbMvPartitionStorage partitionStorage;

    public RocksDbSortedIndexStorage(SortedIndexDescriptor descriptor, ColumnFamily indexCf, RocksDbMvPartitionStorage partitionStorage) {
        this.descriptor = descriptor;
        this.indexCf = indexCf;
        this.partitionStorage = partitionStorage;
    }

    public SortedIndexDescriptor indexDescriptor() {
        return this.descriptor;
    }

    public Cursor<RowId> get(BinaryTuple key) throws StorageException {
        BinaryTuplePrefix keyPrefix = BinaryTuplePrefix.fromBinaryTuple((BinaryTuple)key);
        return CursorUtils.map(this.scan(keyPrefix, keyPrefix, true, true), this::decodeRowId);
    }

    public void put(IndexRow row) {
        WriteBatchWithIndex writeBatch = this.partitionStorage.currentWriteBatch();
        try {
            writeBatch.put(this.indexCf.handle(), this.rocksKey(row), ArrayUtils.BYTE_EMPTY_ARRAY);
        }
        catch (RocksDBException e) {
            throw new StorageException("Unable to insert data into sorted index. Index ID: " + this.descriptor.id(), (Throwable)e);
        }
    }

    public void remove(IndexRow row) {
        WriteBatchWithIndex writeBatch = this.partitionStorage.currentWriteBatch();
        try {
            writeBatch.delete(this.indexCf.handle(), this.rocksKey(row));
        }
        catch (RocksDBException e) {
            throw new StorageException("Unable to remove data from sorted index. Index ID: " + this.descriptor.id(), (Throwable)e);
        }
    }

    public Cursor<IndexRow> scan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        boolean includeLower = (flags & 1) != 0;
        boolean includeUpper = (flags & 2) != 0;
        return CursorUtils.map(this.scan(lowerBound, upperBound, includeLower, includeUpper), this::decodeRow);
    }

    private Cursor<ByteBuffer> scan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, boolean includeLower, boolean includeUpper) {
        byte[] upperBoundBytes;
        byte[] lowerBoundBytes;
        if (lowerBound == null) {
            lowerBoundBytes = null;
        } else {
            lowerBoundBytes = this.rocksPrefix(lowerBound);
            if (!includeLower) {
                RocksDbSortedIndexStorage.setEqualityFlag(lowerBoundBytes);
            }
        }
        if (upperBound == null) {
            upperBoundBytes = null;
        } else {
            upperBoundBytes = this.rocksPrefix(upperBound);
            if (includeUpper) {
                RocksDbSortedIndexStorage.setEqualityFlag(upperBoundBytes);
            }
        }
        return this.createScanCursor(lowerBoundBytes, upperBoundBytes);
    }

    private Cursor<ByteBuffer> createScanCursor(byte @Nullable [] lowerBound, byte @Nullable [] upperBound) {
        final Slice upperBoundSlice = upperBound == null ? new Slice(this.partitionStorage.partitionEndPrefix()) : new Slice(upperBound);
        final ReadOptions options = new ReadOptions().setIterateUpperBound((AbstractSlice)upperBoundSlice);
        RocksIterator it = this.indexCf.newIterator(options);
        if (lowerBound == null) {
            it.seek(this.partitionStorage.partitionStartPrefix());
        } else {
            it.seek(lowerBound);
        }
        return new RocksIteratorAdapter<ByteBuffer>(it){

            protected ByteBuffer decodeEntry(byte[] key, byte[] value) {
                return ByteBuffer.wrap(key).order(ORDER);
            }

            public void close() throws Exception {
                super.close();
                IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{options, upperBoundSlice});
            }
        };
    }

    private static void setEqualityFlag(byte[] prefix) {
        byte flags = prefix[2];
        prefix[2] = (byte)(flags | 0x10);
    }

    private IndexRow decodeRow(ByteBuffer bytes) {
        assert (bytes.getShort(0) == this.partitionStorage.partitionId());
        BinaryTuple tuple = new BinaryTuple(this.descriptor.binaryTupleSchema(), RocksDbSortedIndexStorage.binaryTupleSlice(bytes));
        return new IndexRowImpl(tuple, this.decodeRowId(bytes));
    }

    private RowId decodeRowId(ByteBuffer bytes) {
        long mostSignificantBits = bytes.getLong(bytes.limit() - 16);
        long leastSignificantBits = bytes.getLong(bytes.limit() - 8);
        return new RowId(this.partitionStorage.partitionId(), mostSignificantBits, leastSignificantBits);
    }

    private byte[] rocksPrefix(BinaryTuplePrefix prefix) {
        ByteBuffer bytes = prefix.byteBuffer();
        return ByteBuffer.allocate(2 + bytes.remaining()).order(ORDER).putShort((short)this.partitionStorage.partitionId()).put(bytes).array();
    }

    private byte[] rocksKey(IndexRow row) {
        ByteBuffer bytes = row.indexColumns().byteBuffer();
        return ByteBuffer.allocate(2 + bytes.remaining() + 16).order(ORDER).putShort((short)this.partitionStorage.partitionId()).put(bytes).putLong(row.rowId().mostSignificantBits()).putLong(row.rowId().leastSignificantBits()).array();
    }

    private static ByteBuffer binaryTupleSlice(ByteBuffer key) {
        return key.duplicate().position(2).limit(key.limit() - 16).slice().order(ByteOrder.LITTLE_ENDIAN);
    }
}

