/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.BroadcastExecution;
import org.apache.ignite.compute.JobExecution;

public class BroadcastJobExecutionImpl<R>
implements BroadcastExecution<R> {
    private final Collection<JobExecution<R>> executions;

    public BroadcastJobExecutionImpl(Collection<JobExecution<R>> executions) {
        this.executions = executions;
    }

    public Collection<JobExecution<R>> executions() {
        return List.copyOf(this.executions);
    }

    public CompletableFuture<Collection<R>> resultsAsync() {
        CompletableFuture[] futures = (CompletableFuture[])this.executions.stream().map(JobExecution::resultAsync).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(ignored -> {
            ArrayList result = new ArrayList(futures.length);
            for (CompletableFuture future : futures) {
                result.add(future.join());
            }
            return result;
        });
    }
}

