/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.recovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

@Schema(description="restart partitions configuration.")
public class RestartZonePartitionsRequest {
    @Schema(description="Names specifying nodes to restart zone partitions. Case-sensitive. If empty/omitted, partitions on all nodes are restarted.")
    private final Set<String> nodeNames;
    @Schema(description="Name of the zone to restart partitions of. Without quotes, case-sensitive.")
    private final String zoneName;
    @Schema(description="IDs of partitions to restart. If empty/omitted, all partitions will be restarted.")
    private final Set<Integer> partitionIds;

    @JsonCreator
    public RestartZonePartitionsRequest(@JsonProperty(value="nodeNames") @Nullable Set<String> nodeNames, @JsonProperty(value="zoneName") String zoneName, @JsonProperty(value="partitionIds") @Nullable Collection<Integer> partitionIds) {
        Objects.requireNonNull(zoneName);
        this.zoneName = zoneName;
        this.partitionIds = partitionIds == null ? Set.of() : Set.copyOf(partitionIds);
        this.nodeNames = nodeNames == null ? Set.of() : Set.copyOf(nodeNames);
    }

    @JsonGetter(value="partitionIds")
    public Set<Integer> partitionIds() {
        return this.partitionIds;
    }

    @JsonGetter(value="nodeNames")
    public Set<String> nodeNames() {
        return this.nodeNames;
    }

    @JsonGetter(value="zoneName")
    public String zoneName() {
        return this.zoneName;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

