/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.configuration;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.call.configuration.ClusterConfigShowCallInput;
import org.apache.ignite3.internal.cli.call.configuration.JsonString;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.ClusterConfigurationApi;
import org.apache.ignite3.rest.client.invoker.ApiException;

@Singleton
public class ClusterConfigShowCall
implements Call<ClusterConfigShowCallInput, JsonString> {
    private final ApiClientFactory clientFactory;

    public ClusterConfigShowCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<JsonString> execute(ClusterConfigShowCallInput input) {
        ClusterConfigurationApi client = this.createApiClient(input);
        try {
            return DefaultCallOutput.success(this.readClusterConfig(client, input));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getClusterUrl()));
        }
    }

    private JsonString readClusterConfig(ClusterConfigurationApi api, ClusterConfigShowCallInput input) throws ApiException {
        return JsonString.fromString(input.getSelector() != null ? api.getClusterConfigurationByPath(input.getSelector()) : api.getClusterConfiguration());
    }

    private ClusterConfigurationApi createApiClient(ClusterConfigShowCallInput input) {
        return new ClusterConfigurationApi(this.clientFactory.getClient(input.getClusterUrl()));
    }
}

