/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.PutAllCommand;
import org.apache.ignite3.internal.metastorage.command.PutAllCommandBuilder;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class PutAllCommandDeserializer
implements MessageDeserializer<PutAllCommand> {
    private final PutAllCommandBuilder msg;

    PutAllCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.putAllCommand();
    }

    @Override
    public Class<PutAllCommand> klass() {
        return PutAllCommand.class;
    }

    @Override
    public PutAllCommand getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                HybridTimestamp tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime(tmp);
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readList("keys", MessageCollectionItemType.BYTE_BUFFER);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.keys((List<ByteBuffer>)((Object)tmp));
                reader.incrementState();
            }
            case 2: {
                HybridTimestamp tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.safeTime(tmp);
                reader.incrementState();
            }
            case 3: {
                HybridTimestamp tmp = reader.readList("values", MessageCollectionItemType.BYTE_BUFFER);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.values((List<ByteBuffer>)((Object)tmp));
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(PutAllCommand.class);
    }
}

