/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public enum TxState {
    PENDING(0),
    FINISHING(1),
    ABORTED(2),
    COMMITTED(3),
    ABANDONED(4);

    private static final boolean[][] TRANSITION_MATRIX;
    private final int id;

    public static boolean isFinalState(TxState state) {
        return state == COMMITTED || state == ABORTED;
    }

    public static boolean checkTransitionCorrectness(@Nullable TxState before, TxState after) {
        Objects.requireNonNull(after);
        int beforeOrd = before == null ? 0 : before.ordinal() + 1;
        int afterOrd = after.ordinal() + 1;
        return TRANSITION_MATRIX[beforeOrd][afterOrd];
    }

    private TxState(int id) {
        this.id = id;
    }

    public static TxState fromId(int id) throws IllegalArgumentException {
        switch (id) {
            case 0: {
                return PENDING;
            }
            case 1: {
                return FINISHING;
            }
            case 2: {
                return ABORTED;
            }
            case 3: {
                return COMMITTED;
            }
            case 4: {
                return ABANDONED;
            }
        }
        throw new IllegalArgumentException("No enum constant from id: " + id);
    }

    public int id() {
        return this.id;
    }

    static {
        TRANSITION_MATRIX = new boolean[][]{{false, true, true, true, true, true}, {false, true, true, true, true, true}, {false, false, false, true, true, true}, {false, false, false, true, false, false}, {false, false, false, false, true, false}, {false, false, true, true, true, true}};
    }
}

