/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.message.WriteIntentSwitchReplicaRequest;
import org.apache.ignite3.internal.tx.message.WriteIntentSwitchReplicaRequestBuilder;
import org.apache.ignite3.internal.tx.message.WriteIntentSwitchReplicaRequestSerializer;

public class WriteIntentSwitchReplicaRequestImpl
implements WriteIntentSwitchReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private final boolean commit;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final Set<Integer> tableIds;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID txId;

    private WriteIntentSwitchReplicaRequestImpl(boolean commit, HybridTimestamp commitTimestamp, ReplicationGroupIdMessage groupId, Set<Integer> tableIds, HybridTimestamp timestamp, UUID txId) {
        this.commit = commit;
        this.commitTimestamp = commitTimestamp;
        this.groupId = groupId;
        this.tableIds = tableIds;
        this.timestamp = timestamp;
        this.txId = txId;
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public Set<Integer> tableIds() {
        return this.tableIds;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return WriteIntentSwitchReplicaRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(WriteIntentSwitchReplicaRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WriteIntentSwitchReplicaRequestImpl otherMessage = (WriteIntentSwitchReplicaRequestImpl)other;
        return Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.tableIds, otherMessage.tableIds) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.txId, otherMessage.txId) && this.commit == otherMessage.commit;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commit, this.commitTimestamp, this.groupId, this.tableIds, this.timestamp, this.txId);
        return result;
    }

    @Override
    public WriteIntentSwitchReplicaRequestImpl clone() {
        try {
            return (WriteIntentSwitchReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static WriteIntentSwitchReplicaRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements WriteIntentSwitchReplicaRequestBuilder {
        private boolean commit;
        private HybridTimestamp commitTimestamp;
        private ReplicationGroupIdMessage groupId;
        private Set<Integer> tableIds;
        private HybridTimestamp timestamp;
        private UUID txId;

        private Builder() {
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder commit(boolean commit) {
            this.commit = commit;
            return this;
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder tableIds(Set<Integer> tableIds) {
            Objects.requireNonNull(tableIds, "tableIds is not marked @Nullable");
            this.tableIds = tableIds;
            return this;
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public WriteIntentSwitchReplicaRequestBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean commit() {
            return this.commit;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public Set<Integer> tableIds() {
            return this.tableIds;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public WriteIntentSwitchReplicaRequest build() {
            return new WriteIntentSwitchReplicaRequestImpl(this.commit, this.commitTimestamp, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.tableIds, "tableIds is not marked @Nullable"), this.timestamp, Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }
    }
}

